/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api;

import org.mule.metadata.api.model.MetadataType;

import java.util.Map;

/**
 * A Type Loader capable of listing all available typeIdentifiers with their corresponding MetadataType.
 *
 * @since 1.5
 */
public interface ListableTypeLoader extends TypeLoader {

  /**
   * @return The list of all available typeIdentifiers with their corresponding MetadataType.
   */
  Map<String, MetadataType> getAllTypes();
}
