/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model.impl;

import static org.apache.commons.lang3.ArrayUtils.addAll;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.TupleType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

public class DefaultTupleType extends BaseMetadataType implements TupleType {

  private final List<MetadataType> types;

  public DefaultTupleType(List<MetadataType> types, MetadataFormat metadataFormat,
                          Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    super(metadataFormat, extensions);
    this.types = types;
  }

  private static final Field[] REFLECTION_FIELDS;
  static {
    try {
      REFLECTION_FIELDS = addAll(BASE_REFLECTION_FIELDS,
                                 DefaultTupleType.class.getDeclaredField("types"));
    } catch (NoSuchFieldException e) {
      throw new RuntimeException("Could not resolve field", e);
    }
  }

  @Override
  public Field[] getReflectionComparableFields() {
    return REFLECTION_FIELDS;
  }

  @Override
  public List<MetadataType> getTypes() {
    return types;
  }

  @Override
  public void accept(MetadataTypeVisitor visitor) {
    visitor.visitTuple(this);
  }
}
