/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model.impl;

import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

import javax.xml.namespace.QName;

public class DefaultObjectKeyType extends BaseMetadataType implements ObjectKeyType {

  private final Optional<QName> name;
  private final Optional<Pattern> pattern;
  private final Collection<AttributeFieldType> attributes;

  public DefaultObjectKeyType(Optional<QName> name, Optional<Pattern> pattern, Collection<AttributeFieldType> attributes,
                              MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    super(metadataFormat, extensions);
    this.name = name;
    this.pattern = pattern;
    this.attributes = attributes;
  }

  @Override
  public QName getName() {
    return name.get();
  }

  @Override
  public boolean isName() {
    return name.isPresent();
  }

  @Override
  public Pattern getPattern() {
    return pattern.get();
  }

  @Override
  public boolean isPattern() {
    return pattern.isPresent();
  }

  public Optional<String> getLabel() {
    return getAnnotation(LabelAnnotation.class).map((label) -> label.getValue());
  }

  @Override
  public Collection<AttributeFieldType> getAttributes() {
    return attributes;
  }

  @Override
  public void accept(MetadataTypeVisitor visitor) {
    visitor.visitObjectKey(this);
  }

  @Override
  public String toString() {
    return "DefaultObjectKeyType{name: " + name.toString() + "}";
  }
}
