/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.impl.DefaultNullType;

public class NullTypeBuilder extends AbstractBuilder<NullType> implements TypeBuilder<NullType> {

  protected NullTypeBuilder(MetadataFormat format) {
    super(format);
  }

  @Override
  public NullType build() {
    return new DefaultNullType(format, annotations);
  }
}
