/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.annotation;

import static java.util.Optional.ofNullable;

import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.util.Objects;
import java.util.Optional;

/**
 * Adds a description to the annotated type.
 */
public class DescriptionAnnotation implements TypeAnnotation {

  public static final String NAME = "description";
  private String lang;
  private final String value;

  public DescriptionAnnotation(String value, String lang) {
    this.lang = lang;
    this.value = value;
  }

  public DescriptionAnnotation(String value) {
    this.value = value;
  }

  public Optional<String> getLang() {
    return ofNullable(lang);
  }

  public String getValue() {
    return value;
  }

  @Override
  public String getName() {
    return NAME;
  }

  @Override
  public boolean equals(Object obj) {
    if (obj instanceof DescriptionAnnotation) {
      DescriptionAnnotation other = (DescriptionAnnotation) obj;
      return Objects.equals(value, other.getValue()) && Objects.equals(getLang(), other.getLang());
    }

    return false;
  }

  @Override
  public int hashCode() {
    return new HashCodeBuilder().append(value).append(lang).toHashCode();
  }
}
