/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.utils;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

public final class MetadataTypeUtils {
    private MetadataTypeUtils() {
    }

    public static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static Optional<String> getTypeId(MetadataType type) {
        TypeResolverVisitor visitor = new TypeResolverVisitor();
        type.accept(visitor);
        return Optional.ofNullable(visitor.getResolvedTypeId());
    }

    public static void addTypeAlias(TypeBuilder typeBuilder, String typeAlias) {
        if (typeAlias == null || typeBuilder == null) {
            return;
        }
        if (typeBuilder instanceof WithAnnotation) {
            WithAnnotation withAnnotation = (WithAnnotation)((Object)typeBuilder);
            withAnnotation.with(new TypeAliasAnnotation(typeAlias));
        }
    }

    public static Optional<String> getDefaultValue(MetadataType type) {
        return type.getAnnotation(DefaultValueAnnotation.class).map(DefaultValueAnnotation::getValue);
    }

    public static boolean isVoid(MetadataType type) {
        return type instanceof VoidType;
    }

    public static boolean isCollection(MetadataType type) {
        return type instanceof ArrayType;
    }

    public static boolean isObjectType(MetadataType type) {
        return type instanceof ObjectType;
    }

    public static boolean hasExposedFields(MetadataType type) {
        return type instanceof ObjectType && !((ObjectType)type).getFields().isEmpty();
    }

    public static String getLocalPart(ObjectFieldType field) {
        return field.getKey().getName().getLocalPart();
    }

    public static boolean isEnum(MetadataType type) {
        return type.getAnnotation(EnumAnnotation.class).isPresent();
    }

    public static int hashCode(Optional<?> ... optionals) {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        Stream.of(optionals).filter(Optional::isPresent).forEach(n -> hashCodeBuilder.append(n.get()));
        return hashCodeBuilder.toHashCode();
    }

    public static boolean isNotNull(Object object) {
        return object != null;
    }

    public static class TypeResolverVisitor
    extends MetadataTypeVisitor {
        protected String typeId = null;

        @Override
        public void visitString(StringType stringType) {
            Optional<EnumAnnotation> enumAnnotation = stringType.getAnnotation(EnumAnnotation.class);
            if (enumAnnotation.isPresent()) {
                this.defaultVisit(stringType);
            } else {
                this.typeId = String.class.getName();
            }
        }

        @Override
        public void visitObjectField(ObjectFieldType objectFieldType) {
            objectFieldType.getValue().accept(this);
        }

        @Override
        public void defaultVisit(MetadataType metadataType) {
            this.typeId = metadataType.getAnnotation(TypeIdAnnotation.class).map(TypeIdAnnotation::getValue).orElse(null);
        }

        public String getResolvedTypeId() {
            return this.typeId;
        }
    }
}

