/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.mule.metadata.api.builder.AbstractBuilder;
import org.mule.metadata.api.builder.AttributeFieldTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.impl.DefaultObjectKeyType;

public class ObjectKeyBuilder
extends AbstractBuilder<ObjectKeyType>
implements TypeBuilder<ObjectKeyType> {
    private Optional<QName> name = Optional.empty();
    private Optional<Pattern> pattern = Optional.empty();
    private List<AttributeFieldTypeBuilder> attributes = new ArrayList<AttributeFieldTypeBuilder>();

    public ObjectKeyBuilder(MetadataFormat format) {
        super(format);
    }

    public ObjectKeyBuilder name(String name) {
        this.name = Optional.of(new QName(name));
        return this;
    }

    public ObjectKeyBuilder name(QName name) {
        this.name = Optional.of(name);
        return this;
    }

    public ObjectKeyBuilder pattern(Pattern name) {
        this.pattern = Optional.of(name);
        return this;
    }

    public AttributeFieldTypeBuilder addAttribute() {
        AttributeFieldTypeBuilder attributeBuilder = new AttributeFieldTypeBuilder(this.format);
        this.attributes.add(attributeBuilder);
        return attributeBuilder;
    }

    @Override
    public ObjectKeyType build() {
        if (!this.name.isPresent() && !this.pattern.isPresent()) {
            throw new RuntimeException("No name or pattern was specified.");
        }
        List<AttributeFieldType> attributes = this.attributes.stream().map(builder -> builder.build()).collect(Collectors.toList());
        return new DefaultObjectKeyType(this.name, this.pattern, attributes, this.format, this.annotations);
    }
}

