/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.message.el;


import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.MuleEventMetadataType;
import org.mule.metadata.message.MuleEventMetadataTypeBuilder;

/**
 * Resolves the metadata for a specific expression language.
 */
public interface ExpressionLanguageMetadataTypeResolver {

  /**
   * Infers the expected input mule event type {@link MuleEventMetadataType} for specified output type with the given script.
   *
   * @param expression The scripting text.
   * @param output The expected output type
   * @param builder The builder to be used to build the event type
   * @param callback The callback
   */
  void getInputType(String expression, MetadataType output, MuleEventMetadataTypeBuilder builder, MessageCallback callback);

  /**
   * Returns the result type expression when invoked with the given {@link MuleEventMetadataType}.
   * @param input The input type
   * @param expression The scripting text.
   * @param callback The callback
   * @return The return type of the expression.
   */
  MetadataType getOutputType(MuleEventMetadataType input, String expression, MessageCallback callback);

  /**
   * Callback from the resolver
   */
  interface MessageCallback {

    /**
     * Is called when a warning message happens while resolving metadata
     * @param message The message
     */
    void warning(String message);

    /**
     * Is called when a error message happens while resolving metadata
     * @param message The message
     */
    void error(String message);
  }
}
