/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.message;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;

import java.util.Optional;


/**
 * Models a Message Type with its payload and attributes.
 *
 * @see MuleEventMetadataType
 * @since 1.0
 */
public interface MessageMetadataType extends ObjectType {

  static MessageMetadataTypeBuilder builder() {
    return new MessageMetadataTypeBuilder();
  }

  /**
   * The payload metadata types
   *
   * @return The payload type
   */
  Optional<MetadataType> getPayloadType();

  /**
   * The attributes metadata type
   *
   * @return The attribute type
   */
  Optional<MetadataType> getAttributesType();
}
