/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.http.api.client.proxy;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

import java.util.concurrent.CompletableFuture;

/**
 * Factory for generating custom authentication headers for proxy authentication.
 *
 * @since 4.10.0
 */
@NoImplement
public interface AuthHeaderFactory {

  /**
   * Indicates whether the authentication process has completed.
   *
   * @return true if authentication is finished
   */
  boolean hasFinished();

  /**
   * Generates an authentication header.
   *
   * @param response the HTTP response containing authentication challenges in headers, or null for preemptive auth.
   * @return a CompletableFuture that resolves to the authentication header value, or completes exceptionally for any
   *         error/failure cases when the header cannot be generated
   */
  CompletableFuture<String> generateHeader(HttpResponse response);
}
