/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain.entity;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.util.IOUtils;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;

@Feature(value="HTTP Service")
@Story(value="Entities")
public class InputStreamHttpEntityTestCase {
    private InputStream stream = new InputStream(){
        private boolean once = false;

        @Override
        public int read() {
            if (this.once) {
                return -1;
            }
            this.once = true;
            return 43;
        }
    };
    private HttpEntity entity = new InputStreamHttpEntity(this.stream);

    @Test
    public void nonComposed() {
        Assert.assertThat((Object)this.entity.isComposed(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void streaming() {
        Assert.assertThat((Object)this.entity.isStreaming(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void providesArrayOnce() throws IOException {
        Assert.assertThat((Object)this.entity.getBytes().length, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.entity.getBytes().length, (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void providesStreamOnce() {
        InputStream content = this.entity.getContent();
        Assert.assertThat((Object)content, (Matcher)Matchers.equalTo((Object)this.stream));
        Assert.assertThat((Object)IOUtils.toByteArray((InputStream)content), (Matcher)Matchers.equalTo((Object)"+".getBytes()));
        Assert.assertThat((Object)IOUtils.toByteArray((InputStream)this.entity.getContent()).length, (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void hasNoParts() throws IOException {
        Assert.assertThat((Object)this.entity.getParts(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void hasNoSizeUnlessSpecified() {
        Assert.assertThat((Object)this.entity.getBytesLength().isPresent(), (Matcher)Matchers.is((Object)false));
        InputStreamHttpEntity specifiedEntity = new InputStreamHttpEntity((InputStream)new ByteArrayInputStream("TEST".getBytes()), 4L);
        Assert.assertThat((Object)specifiedEntity.getBytesLength().getAsLong(), (Matcher)Matchers.is((Object)4L));
    }
}

