/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.ws;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum WebSocketCloseCode {
    NORMAL_CLOSURE(1000),
    ENDPOINT_GOING_DOWN(1001),
    PROTOCOL_ERROR(1002),
    INVALID_DATA(1003),
    MESSAGE_TOO_LARGE(1004),
    INVALID_PAYLOAD(1007),
    POLICY_VIOLATION(1008),
    MESSAGE_TOO_BIG(1009),
    MISSING_EXTENSIONS(1010),
    INTERNAL_SERVER_ERROR(1011),
    SERVICE_RESTARTED(1012),
    TRY_AGAIN_LATER(1013),
    BAD_GATEWAY(1014),
    UNKNOWN(-1);

    private static final Map<Integer, WebSocketCloseCode> CODES;
    private static final Logger LOGGER;
    private final int protocolCode;
    private int originalCode;

    public static WebSocketCloseCode fromProtocolCode(int protocolCode) {
        WebSocketCloseCode code = CODES.get(protocolCode);
        if (code == null) {
            if (WebSocketCloseCode.isPrivateUseCode(protocolCode)) {
                LOGGER.debug("Received private use WebSocket close code: {}", (Object)protocolCode);
            } else if (WebSocketCloseCode.isRegisteredCode(protocolCode)) {
                LOGGER.debug("Received library/framework WebSocket close code: {}", (Object)protocolCode);
            } else if (WebSocketCloseCode.isReservedCode(protocolCode)) {
                LOGGER.debug("Received undefined reserved WebSocket close code: {}", (Object)protocolCode);
            } else {
                throw new IllegalArgumentException("Received invalid WebSocket close code:" + protocolCode);
            }
            return WebSocketCloseCode.unknownWithCode(protocolCode);
        }
        return code;
    }

    private WebSocketCloseCode(int protocolCode) {
        this.protocolCode = protocolCode;
        this.originalCode = protocolCode;
    }

    public static WebSocketCloseCode unknownWithCode(int originalCode) {
        WebSocketCloseCode unknown = UNKNOWN;
        unknown.originalCode = originalCode;
        return unknown;
    }

    public int getProtocolCode() {
        return this.protocolCode;
    }

    public int getOriginalCode() {
        return this.originalCode;
    }

    public static boolean isReservedCode(int code) {
        return code >= 1000 && code <= 2999;
    }

    public static boolean isRegisteredCode(int code) {
        return code >= 3000 && code <= 3999;
    }

    public static boolean isPrivateUseCode(int code) {
        return code >= 4000 && code <= 4999;
    }

    static {
        CODES = new HashMap<Integer, WebSocketCloseCode>(WebSocketCloseCode.values().length);
        LOGGER = LoggerFactory.getLogger(WebSocketCloseCode.class);
        for (WebSocketCloseCode code : WebSocketCloseCode.values()) {
            if (code.protocolCode == -1) continue;
            CODES.put(code.protocolCode, code);
        }
    }
}

