/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.tcp;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.mule.runtime.http.api.tcp.TcpClientSocketPropertiesBuilder;

@Feature(value="HTTP Service")
@Story(value="TCP Builders")
public class TcpClientSocketPropertiesBuilderTestCase {
    TcpClientSocketPropertiesBuilder builder = TcpClientSocketProperties.builder();

    @Test
    public void defaultConfiguration() {
        TcpClientSocketProperties properties = this.builder.build();
        Assert.assertThat((Object)properties.getConnectionTimeout(), (Matcher)Matchers.is((Object)30000));
        Assert.assertThat((Object)properties.getKeepAlive(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)properties.getSendTcpNoDelay(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)properties.getSendBufferSize(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)properties.getReceiveBufferSize(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)properties.getLinger(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)properties.getClientTimeout(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void complexConfiguration() {
        TcpClientSocketProperties properties = this.builder.connectionTimeout(Integer.valueOf(1)).keepAlive(Boolean.valueOf(true)).sendTcpNoDelay(Boolean.valueOf(false)).sendBufferSize(Integer.valueOf(2)).receiveBufferSize(Integer.valueOf(3)).linger(Integer.valueOf(4)).clientTimeout(Integer.valueOf(5)).build();
        Assert.assertThat((Object)properties.getConnectionTimeout(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)properties.getKeepAlive(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)properties.getSendTcpNoDelay(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)properties.getSendBufferSize(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)properties.getReceiveBufferSize(), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)properties.getLinger(), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)properties.getClientTimeout(), (Matcher)Matchers.is((Object)5));
    }
}

