/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain.entity.multipart;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.entity.multipart.MultipartHttpEntity;

@Feature(value="HTTP Service")
@Story(value="Entities")
public class MultipartHttpEntityTestCase {
    HttpPart part1 = (HttpPart)Mockito.mock(HttpPart.class);
    HttpPart part2 = (HttpPart)Mockito.mock(HttpPart.class);
    private HttpEntity entity = new MultipartHttpEntity(Arrays.asList(this.part1, this.part2));

    @Test
    public void composed() {
        Assert.assertThat((Object)this.entity.isComposed(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void nonStreaming() {
        Assert.assertThat((Object)this.entity.isStreaming(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void doesNotProvideArray() throws IOException {
        Assert.assertThat((Object)this.entity.getBytes(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void doesNotProvideStream() throws IOException {
        Assert.assertThat((Object)this.entity.getContent(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void hasParts() throws IOException {
        Collection parts = this.entity.getParts();
        Assert.assertThat((Object)parts, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)parts, (Matcher)Matchers.contains((Object[])new HttpPart[]{this.part1, this.part2}));
    }

    @Test
    public void hasNoSize() {
        Assert.assertThat((Object)this.entity.getBytesLength().isPresent(), (Matcher)Matchers.is((Object)false));
    }
}

