/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.http.api.domain.entity;

/**
 * Factory for instances of implementation-specific {@link HttpEntity}s.
 *
 * @since 4.11
 */
public interface EntityFactory {

  /**
   * @return a {@link FeedableHttpEntity} with unknown total length.
   */
  FeedableHttpEntity feedable();

  /**
   * @param knownLength the known content-length.
   * @return a {@link FeedableHttpEntity} with known total content length.
   */
  FeedableHttpEntity feedable(long knownLength);
}
