/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.http.api;

import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoImplement;

/**
 * Allows enabling/disabling and configuring HTTP/1 specific parameters.
 *
 * @since 4.10
 */
@Experimental
@NoImplement
public class Http1ProtocolConfig {

  private boolean enabled;

  public Http1ProtocolConfig(boolean enabled) {
    this.enabled = enabled;
  }

  /**
   * @return whether HTTP/1 should be enabled or not.
   */
  public boolean isEnabled() {
    return enabled;
  }

  /**
   * Enables or disables HTTP/1 support.
   *
   * @param enabled whether it should be enabled or not. Default is {@code true}.
   * @return this config.
   */
  public Http1ProtocolConfig setEnabled(boolean enabled) {
    this.enabled = enabled;
    return this;
  }
}
