/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain.entity;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;

@Feature(value="HTTP Service")
@Story(value="Entities")
public class EmptyHttpEntityTestCase {
    private HttpEntity entity = new EmptyHttpEntity();

    @Test
    public void nonComposed() {
        Assert.assertThat((Object)this.entity.isComposed(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void nonStreaming() {
        Assert.assertThat((Object)this.entity.isStreaming(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void providesEmptyArray() throws IOException {
        Assert.assertThat((Object)this.entity.getBytes().length, (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void providesNewEmptyStream() throws IOException {
        Assert.assertThat((Object)this.entity.getContent().read(), (Matcher)Matchers.is((Object)-1));
        Assert.assertThat((Object)this.entity.getContent().read(), (Matcher)Matchers.is((Object)-1));
    }

    @Test
    public void hasNoParts() throws IOException {
        Assert.assertThat((Object)this.entity.getParts(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void hasZeroSize() {
        Assert.assertThat((Object)this.entity.getBytesLength().getAsLong(), (Matcher)Matchers.is((Object)0L));
    }
}

