/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain.entity;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.util.IOUtils;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;

@Feature(value="HTTP Service")
@Story(value="Entities")
public class ByteArrayHttpEntityTestCase {
    private byte[] content = "TEST".getBytes();
    private HttpEntity entity = new ByteArrayHttpEntity(this.content);

    @Test
    public void nonComposed() {
        Assert.assertThat((Object)this.entity.isComposed(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void nonStreaming() {
        Assert.assertThat((Object)this.entity.isStreaming(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void providesArray() throws IOException {
        Assert.assertThat((Object)this.entity.getBytes(), (Matcher)Matchers.equalTo((Object)this.content));
    }

    @Test
    public void providesNewStream() throws IOException {
        Assert.assertThat((Object)IOUtils.toByteArray((InputStream)this.entity.getContent()), (Matcher)Matchers.equalTo((Object)this.content));
        Assert.assertThat((Object)IOUtils.toByteArray((InputStream)this.entity.getContent()), (Matcher)Matchers.equalTo((Object)this.content));
    }

    @Test
    public void hasNoParts() throws IOException {
        Assert.assertThat((Object)this.entity.getParts(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void providesSize() {
        Assert.assertThat((Object)this.entity.getBytesLength().getAsLong(), (Matcher)Matchers.is((Object)this.content.length));
    }
}

