/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.ws;

import io.qameta.allure.Issue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.http.api.ws.WebSocketCloseCode;

@Issue(value="W-17846088")
public class WebSocketCloseCodeTestCase {
    @Test
    public void testFromProtocolCodeWithKnownCodes() {
        MatcherAssert.assertThat((Object)WebSocketCloseCode.fromProtocolCode((int)1000), (Matcher)Matchers.is((Object)WebSocketCloseCode.NORMAL_CLOSURE));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.fromProtocolCode((int)1001), (Matcher)Matchers.is((Object)WebSocketCloseCode.ENDPOINT_GOING_DOWN));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.fromProtocolCode((int)1002), (Matcher)Matchers.is((Object)WebSocketCloseCode.PROTOCOL_ERROR));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.fromProtocolCode((int)1003), (Matcher)Matchers.is((Object)WebSocketCloseCode.INVALID_DATA));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.fromProtocolCode((int)1004), (Matcher)Matchers.is((Object)WebSocketCloseCode.MESSAGE_TOO_LARGE));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.fromProtocolCode((int)1007), (Matcher)Matchers.is((Object)WebSocketCloseCode.INVALID_PAYLOAD));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.fromProtocolCode((int)1008), (Matcher)Matchers.is((Object)WebSocketCloseCode.POLICY_VIOLATION));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.fromProtocolCode((int)1009), (Matcher)Matchers.is((Object)WebSocketCloseCode.MESSAGE_TOO_BIG));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.fromProtocolCode((int)1010), (Matcher)Matchers.is((Object)WebSocketCloseCode.MISSING_EXTENSIONS));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.fromProtocolCode((int)1011), (Matcher)Matchers.is((Object)WebSocketCloseCode.INTERNAL_SERVER_ERROR));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.fromProtocolCode((int)1012), (Matcher)Matchers.is((Object)WebSocketCloseCode.SERVICE_RESTARTED));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.fromProtocolCode((int)1013), (Matcher)Matchers.is((Object)WebSocketCloseCode.TRY_AGAIN_LATER));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.fromProtocolCode((int)1014), (Matcher)Matchers.is((Object)WebSocketCloseCode.BAD_GATEWAY));
    }

    @Test
    public void fromProtocolCodeWithPrivateUseCode() {
        WebSocketCloseCode code = WebSocketCloseCode.fromProtocolCode((int)4500);
        MatcherAssert.assertThat((Object)code, (Matcher)Matchers.is((Object)WebSocketCloseCode.UNKNOWN));
        MatcherAssert.assertThat((Object)code.getOriginalCode(), (Matcher)Matchers.is((Object)4500));
    }

    @Test
    public void fromProtocolCodeWithRegisteredCode() {
        WebSocketCloseCode code = WebSocketCloseCode.fromProtocolCode((int)3500);
        MatcherAssert.assertThat((Object)code, (Matcher)Matchers.is((Object)WebSocketCloseCode.UNKNOWN));
        MatcherAssert.assertThat((Object)code.getOriginalCode(), (Matcher)Matchers.is((Object)3500));
    }

    @Test
    public void fromProtocolCodeWithReservedCode() {
        WebSocketCloseCode code = WebSocketCloseCode.fromProtocolCode((int)2500);
        MatcherAssert.assertThat((Object)code, (Matcher)Matchers.is((Object)WebSocketCloseCode.UNKNOWN));
        MatcherAssert.assertThat((Object)code.getOriginalCode(), (Matcher)Matchers.is((Object)2500));
    }

    @Test(expected=IllegalArgumentException.class)
    public void fromProtocolCodeWithInvalidCodeThrowsException() {
        WebSocketCloseCode.fromProtocolCode((int)5000);
    }

    @Test
    public void unknownWithCodeSetsOriginalCode() {
        WebSocketCloseCode code = WebSocketCloseCode.unknownWithCode((int)9999);
        MatcherAssert.assertThat((Object)code, (Matcher)Matchers.is((Object)WebSocketCloseCode.UNKNOWN));
        MatcherAssert.assertThat((Object)code.getOriginalCode(), (Matcher)Matchers.is((Object)9999));
    }

    @Test
    public void getProtocolCodeReturnsCorrectCode() {
        MatcherAssert.assertThat((Object)WebSocketCloseCode.NORMAL_CLOSURE.getProtocolCode(), (Matcher)Matchers.is((Object)1000));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.UNKNOWN.getProtocolCode(), (Matcher)Matchers.is((Object)-1));
    }

    @Test
    public void isReservedCodeReturnsCorrectBoolean() {
        MatcherAssert.assertThat((Object)WebSocketCloseCode.isReservedCode((int)1000), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.isReservedCode((int)2999), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.isReservedCode((int)999), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.isReservedCode((int)3000), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void isRegisteredCodeReturnsCorrectBoolean() {
        MatcherAssert.assertThat((Object)WebSocketCloseCode.isRegisteredCode((int)3000), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.isRegisteredCode((int)3999), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.isRegisteredCode((int)2999), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.isRegisteredCode((int)4000), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void isPrivateUseCodeReturnsCorrectBoolean() {
        MatcherAssert.assertThat((Object)WebSocketCloseCode.isPrivateUseCode((int)4000), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.isPrivateUseCode((int)4999), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.isPrivateUseCode((int)3999), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)WebSocketCloseCode.isPrivateUseCode((int)5000), (Matcher)Matchers.is((Object)false));
    }
}

