/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.client.auth;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.auth.HttpAuthenticationType;

@Feature(value="HTTP Service")
@Story(value="Authentication Builder")
public class HttpAuthenticationBuilderTestCase {
    @Test
    void builder() {
        HttpAuthentication auth = HttpAuthentication.builder().type(HttpAuthenticationType.BASIC).username("Helena").password("s33stra").build();
        MatcherAssert.assertThat((Object)auth.getType(), (Matcher)Is.is((Object)HttpAuthenticationType.BASIC));
        MatcherAssert.assertThat((Object)auth.getUsername(), (Matcher)Is.is((Object)"Helena"));
        MatcherAssert.assertThat((Object)auth.getPassword(), (Matcher)Is.is((Object)"s33stra"));
        MatcherAssert.assertThat((Object)auth.isPreemptive(), (Matcher)Is.is((Object)true));
    }

    @Test
    void ntlmBuilder() {
        HttpAuthentication.HttpNtlmAuthentication auth = HttpAuthentication.HttpNtlmAuthentication.builder().username("Allison").password("suburbia").domain("CA").build();
        MatcherAssert.assertThat((Object)auth.getType(), (Matcher)Is.is((Object)HttpAuthenticationType.NTLM));
        MatcherAssert.assertThat((Object)auth.getUsername(), (Matcher)Is.is((Object)"Allison"));
        MatcherAssert.assertThat((Object)auth.getPassword(), (Matcher)Is.is((Object)"suburbia"));
        MatcherAssert.assertThat((Object)auth.getDomain(), (Matcher)Is.is((Object)"CA"));
        MatcherAssert.assertThat((Object)auth.getWorkstation(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
    }

    @Test
    void basic() {
        HttpAuthentication auth = HttpAuthentication.basic((String)"Sarah", (String)"l3D4").build();
        MatcherAssert.assertThat((Object)auth.getType(), (Matcher)Is.is((Object)HttpAuthenticationType.BASIC));
        MatcherAssert.assertThat((Object)auth.getUsername(), (Matcher)Is.is((Object)"Sarah"));
        MatcherAssert.assertThat((Object)auth.getPassword(), (Matcher)Is.is((Object)"l3D4"));
    }

    @Test
    void digest() {
        HttpAuthentication auth = HttpAuthentication.digest((String)"Cosima", (String)"324B21").preemptive(false).build();
        MatcherAssert.assertThat((Object)auth.getType(), (Matcher)Is.is((Object)HttpAuthenticationType.DIGEST));
        MatcherAssert.assertThat((Object)auth.getUsername(), (Matcher)Is.is((Object)"Cosima"));
        MatcherAssert.assertThat((Object)auth.getPassword(), (Matcher)Is.is((Object)"324B21"));
        MatcherAssert.assertThat((Object)auth.isPreemptive(), (Matcher)Is.is((Object)false));
    }

    @Test
    void ntlm() {
        HttpAuthentication.HttpNtlmAuthentication auth = HttpAuthentication.ntlm((String)"Rachel", (String)"Cold B Digest").domain("DYAD").workstation("MyPC").build();
        MatcherAssert.assertThat((Object)auth.getType(), (Matcher)Is.is((Object)HttpAuthenticationType.NTLM));
        MatcherAssert.assertThat((Object)auth.getUsername(), (Matcher)Is.is((Object)"Rachel"));
        MatcherAssert.assertThat((Object)auth.getPassword(), (Matcher)Is.is((Object)"Cold B Digest"));
        MatcherAssert.assertThat((Object)auth.isPreemptive(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)auth.getDomain(), (Matcher)Is.is((Object)"DYAD"));
        MatcherAssert.assertThat((Object)auth.getWorkstation(), (Matcher)Is.is((Object)"MyPC"));
    }

    @Test
    void failWithoutType() {
        NullPointerException thrown = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> HttpAuthentication.builder().username("Tony").password("W4T").build());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Object)"An authentication type must be declared."));
    }

    @Test
    void failWithoutUsername() {
        NullPointerException thrown = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> HttpAuthentication.builder().type(HttpAuthenticationType.DIGEST).password("C4s70r").build());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Object)"A username must be provided."));
    }

    @Test
    void failWithoutPassword() {
        NullPointerException thrown = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> HttpAuthentication.HttpNtlmAuthentication.builder().type(HttpAuthenticationType.NTLM).username("Krystal").build());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Object)"A password must be provided."));
    }
}

