/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.test.internal.loader.validator;

import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.core.IsNot;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.internal.loader.validator.NameModelValidator;

@RunWith(value=MockitoJUnitRunner.class)
public class NameModelValidatorTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    ExtensionModel extensionModel;
    @Mock
    OperationModel operationModel;
    @Mock
    FunctionModel functionModel;
    private NameModelValidator nameModelValidator;
    private ProblemsReporter problemsReporter;

    @Before
    public void setUp() {
        this.nameModelValidator = new NameModelValidator();
        this.problemsReporter = new ProblemsReporter(this.extensionModel);
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Collections.singletonList(this.operationModel));
        Mockito.when((Object)this.extensionModel.getFunctionModels()).thenReturn(Collections.singletonList(this.functionModel));
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"validName");
        Mockito.when((Object)this.functionModel.getName()).thenReturn((Object)"validName");
    }

    @Test
    public void camelCaseName() {
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"validName");
        this.nameModelValidator.validate(this.extensionModel, this.problemsReporter);
        this.assertSuccess();
    }

    @Test
    public void xmlTypeName() {
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"xmlTypeName");
        this.nameModelValidator.validate(this.extensionModel, this.problemsReporter);
        this.assertSuccess();
    }

    @Test
    public void invalidOperationName() {
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"inval;id");
        this.nameModelValidator.validate(this.extensionModel, this.problemsReporter);
        this.assertError("Names should follow: http://www.w3.org/TR/xmlschema-2/#NCName");
    }

    @Test
    public void functionStartingWithANumber() {
        Mockito.when((Object)this.functionModel.getName()).thenReturn((Object)"123");
        this.nameModelValidator.validate(this.extensionModel, this.problemsReporter);
        this.assertError("Function names can't start with a number.");
    }

    @Test
    public void functionNotAlphanumeric() {
        Mockito.when((Object)this.functionModel.getName()).thenReturn((Object)"hi**");
        this.nameModelValidator.validate(this.extensionModel, this.problemsReporter);
        this.assertError("Function names must be alpha numeric.");
    }

    private void assertError(String errorMessage) {
        List errors = this.problemsReporter.getErrors();
        MatcherAssert.assertThat((Object)errors, (Matcher)CoreMatchers.is((Matcher)IsNot.not((Matcher)IsEmptyCollection.empty())));
        MatcherAssert.assertThat((Object)((Problem)errors.get(0)).getMessage(), (Matcher)CoreMatchers.containsString((String)errorMessage));
    }

    private void assertSuccess() {
        List errors = this.problemsReporter.getErrors();
        MatcherAssert.assertThat((Object)errors, (Matcher)CoreMatchers.is((Matcher)IsEmptyCollection.empty()));
    }
}

