/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.test.declaration.type;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsIterableContaining;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.metadata.api.builder.AnyTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.handler.ObjectFieldHandler;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.declaration.type.ExtensionObjectTypeHandler;
import org.mule.runtime.extension.api.declaration.type.annotation.LiteralTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ParameterResolverTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.TypedValueTypeAnnotation;
import org.mule.runtime.extension.api.test.internal.loader.TestingClass;
import org.mule.sdk.api.runtime.parameter.Literal;
import org.mule.sdk.api.runtime.parameter.ParameterResolver;

public class ExtensionObjectTypeHandlerTestCase {
    private ExtensionObjectTypeHandler handler;
    private TypeHandlerManager typeHandlerManager;
    private ParsingContext parsingContext;

    @Before
    public void setUp() {
        this.handler = new ExtensionObjectTypeHandler((ObjectFieldHandler)Mockito.mock(ObjectFieldHandler.class));
        this.typeHandlerManager = (TypeHandlerManager)Mockito.mock(TypeHandlerManager.class);
        Mockito.when((Object)this.typeHandlerManager.handle((Type)ArgumentMatchers.any(), (ParsingContext)ArgumentMatchers.any(), (BaseTypeBuilder)ArgumentMatchers.any())).then(inv -> {
            AnyTypeBuilder newBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).anyType();
            ((ParsingContext)inv.getArgument(1, ParsingContext.class)).addTypeBuilder((Type)inv.getArgument(0, Type.class), (TypeBuilder)newBuilder);
            return newBuilder;
        });
        this.parsingContext = new ParsingContext();
    }

    @Test
    public void passThrough() {
        this.handler.handleClass(TestingClass.class, Collections.emptyList(), this.typeHandlerManager, this.parsingContext, BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA));
        MetadataType type = ((TypeBuilder)this.parsingContext.getTypeBuilder(TestingClass.class).get()).build();
        MatcherAssert.assertThat((Object)type.getAnnotations(), (Matcher)Matchers.not((Matcher)IsIterableContaining.hasItems((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(ParameterResolverTypeAnnotation.class), IsInstanceOf.instanceOf(LiteralTypeAnnotation.class), IsInstanceOf.instanceOf(TypedValueTypeAnnotation.class)})));
    }

    @Test
    public void parameterResolver() {
        this.handler.handleClass(ParameterResolver.class, Collections.singletonList(TestingClass.class), this.typeHandlerManager, this.parsingContext, BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA));
        MatcherAssert.assertThat((Object)this.parsingContext.getTypeBuilder(TestingClass.class), (Matcher)Matchers.is(Optional.empty()));
        MetadataType type = ((TypeBuilder)this.parsingContext.getSubContext(ParameterResolver.class.getName()).getTypeBuilder(TestingClass.class).get()).build();
        MatcherAssert.assertThat((Object)type.getAnnotations(), (Matcher)IsIterableContaining.hasItem((Matcher)IsInstanceOf.instanceOf(ParameterResolverTypeAnnotation.class)));
        MatcherAssert.assertThat((Object)type.getAnnotations(), (Matcher)Matchers.not((Matcher)IsIterableContaining.hasItems((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(LiteralTypeAnnotation.class), IsInstanceOf.instanceOf(TypedValueTypeAnnotation.class)})));
    }

    @Test
    public void typedValue() {
        this.handler.handleClass(TypedValue.class, Collections.singletonList(TestingClass.class), this.typeHandlerManager, this.parsingContext, BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA));
        MatcherAssert.assertThat((Object)this.parsingContext.getTypeBuilder(TestingClass.class), (Matcher)Matchers.is(Optional.empty()));
        MetadataType type = ((TypeBuilder)this.parsingContext.getSubContext(TypedValue.class.getName()).getTypeBuilder(TestingClass.class).get()).build();
        MatcherAssert.assertThat((Object)type.getAnnotations(), (Matcher)IsIterableContaining.hasItem((Matcher)IsInstanceOf.instanceOf(TypedValueTypeAnnotation.class)));
        MatcherAssert.assertThat((Object)type.getAnnotations(), (Matcher)Matchers.not((Matcher)IsIterableContaining.hasItems((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(ParameterResolverTypeAnnotation.class), IsInstanceOf.instanceOf(LiteralTypeAnnotation.class)})));
    }

    @Test
    public void literal() {
        this.handler.handleClass(Literal.class, Collections.singletonList(TestingClass.class), this.typeHandlerManager, this.parsingContext, BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA));
        MatcherAssert.assertThat((Object)this.parsingContext.getTypeBuilder(TestingClass.class), (Matcher)Matchers.is(Optional.empty()));
        MetadataType type = ((TypeBuilder)this.parsingContext.getSubContext(Literal.class.getName()).getTypeBuilder(TestingClass.class).get()).build();
        MatcherAssert.assertThat((Object)type.getAnnotations(), (Matcher)IsIterableContaining.hasItem((Matcher)IsInstanceOf.instanceOf(LiteralTypeAnnotation.class)));
        MatcherAssert.assertThat((Object)type.getAnnotations(), (Matcher)Matchers.not((Matcher)IsIterableContaining.hasItems((Matcher[])new Matcher[]{IsInstanceOf.instanceOf(ParameterResolverTypeAnnotation.class), IsInstanceOf.instanceOf(TypedValueTypeAnnotation.class)})));
    }
}

