/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.model.parameter;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.deprecated.DeprecableModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.stereotype.HasStereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.version.HasMinMuleVersion;
import org.mule.runtime.extension.api.model.parameter.AbstractParameterizedModel;

public abstract class AbstractStereotypedModel
extends AbstractParameterizedModel
implements HasStereotypeModel,
DeprecableModel,
HasMinMuleVersion {
    private final StereotypeModel stereotype;
    private final DeprecationModel deprecationModel;
    private final MuleVersion minMuleVersion;

    public AbstractStereotypedModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, DisplayModel displayModel, StereotypeModel stereotype, Set<ModelProperty> modelProperties) {
        this(name, description, parameterGroupModels, displayModel, stereotype, modelProperties, null);
    }

    public AbstractStereotypedModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, DisplayModel displayModel, StereotypeModel stereotype, Set<ModelProperty> modelProperties, DeprecationModel deprecationModel) {
        this(name, description, parameterGroupModels, displayModel, stereotype, modelProperties, deprecationModel, null);
    }

    public AbstractStereotypedModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, DisplayModel displayModel, StereotypeModel stereotype, Set<ModelProperty> modelProperties, DeprecationModel deprecationModel, MuleVersion minMuleVersion) {
        super(name, description, parameterGroupModels, displayModel, modelProperties);
        this.stereotype = stereotype;
        this.deprecationModel = deprecationModel;
        this.minMuleVersion = minMuleVersion;
    }

    public StereotypeModel getStereotype() {
        return this.stereotype;
    }

    public Optional<DeprecationModel> getDeprecationModel() {
        return Optional.ofNullable(this.deprecationModel);
    }

    public boolean isDeprecated() {
        return this.deprecationModel != null;
    }

    public Optional<MuleVersion> getMinMuleVersion() {
        return Optional.ofNullable(this.minMuleVersion);
    }

    @Override
    public String toString() {
        return "AbstractStereotypedModel{stereotype=" + this.stereotype + ", deprecationModel=" + this.deprecationModel + ", minMuleVersion=" + this.minMuleVersion + "} " + super.toString();
    }
}

