/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.test.internal.loader;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.test.internal.loader.TestingClass;
import org.mule.runtime.extension.internal.loader.CachedClassTypeLoader;

public class CachedClassTypeLoaderTestCase {
    private ClassTypeLoader cachedLoader;

    @Before
    public void setUp() {
        this.cachedLoader = new CachedClassTypeLoader(ExtensionsTypeLoaderFactory.getDefault().createTypeLoader());
    }

    @Test
    public void cacheByType() {
        MetadataType metadataType = this.cachedLoader.load(TestingClass.class);
        MatcherAssert.assertThat((Object)this.cachedLoader.load(TestingClass.class), (Matcher)Matchers.sameInstance((Object)metadataType));
    }

    @Test
    public void cacheByIdentifier() {
        MetadataType metadataType = (MetadataType)this.cachedLoader.load(TestingClass.class.getName()).get();
        MatcherAssert.assertThat((Object)((MetadataType)this.cachedLoader.load(TestingClass.class.getName()).get()), (Matcher)Matchers.sameInstance((Object)metadataType));
    }

    @Test
    public void cacheByTypeQueryByIdentifier() {
        MetadataType metadataType = this.cachedLoader.load(TestingClass.class);
        MatcherAssert.assertThat((Object)((MetadataType)this.cachedLoader.load(TestingClass.class.getName()).get()), (Matcher)Matchers.sameInstance((Object)metadataType));
    }

    @Test
    public void cacheByIdentifierQueryByType() {
        MetadataType metadataType = (MetadataType)this.cachedLoader.load(TestingClass.class.getName()).get();
        MatcherAssert.assertThat((Object)this.cachedLoader.load(TestingClass.class), (Matcher)Matchers.sameInstance((Object)metadataType));
    }
}

