/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type;

import com.google.common.collect.Sets;
import java.util.Collections;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.InfrastructureTypeBuilder;
import org.mule.runtime.extension.api.declaration.type.annotation.ExclusiveOptionalsTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.InfrastructureTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;

public final class RedeliveryPolicyTypeBuilder
extends InfrastructureTypeBuilder {
    public static final String MAX_REDELIVERY_COUNT = "maxRedeliveryCount";
    public static final String USE_SECURE_HASH = "useSecureHash";
    public static final String MESSAGE_DIGEST_ALGORITHM = "messageDigestAlgorithm";
    public static final String ID_EXPRESSION = "idExpression";
    public static final String OBJECT_STORE_REF = "objectStore";
    public static final String REDELIVERY_POLICY = "RedeliveryPolicy";
    public static final String MESSAGE_IDENTIFIER = "MessageIdentifier";

    public MetadataType buildRedeliveryPolicyType() {
        ObjectTypeBuilder objectType = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().id(REDELIVERY_POLICY);
        BaseTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
        objectType.with((TypeAnnotation)new InfrastructureTypeAnnotation());
        this.addIntField(objectType, typeBuilder, MAX_REDELIVERY_COUNT, "The maximum number of times a message can be redelivered and processed unsuccessfully before triggering process-failed-message", 5);
        this.addStringField(objectType, typeBuilder, MESSAGE_DIGEST_ALGORITHM, "The secure hashing algorithm to use. If not set, the default is SHA-256.", null);
        objectType.addField().with((TypeAnnotation)new FlattenedTypeAnnotation()).description("Defines which strategy is used to identify the messages.").key(MESSAGE_IDENTIFIER).value(this.buildMessageFilterType());
        objectType.addField().with((TypeAnnotation)new StereotypeTypeAnnotation(Collections.singletonList(MuleStereotypes.OBJECT_STORE))).description("The object store where the redelivery counter for each message is going to be stored.").key(OBJECT_STORE_REF).value(ExtensionsTypeLoaderFactory.getDefault().createTypeLoader().load(ObjectStore.class));
        return objectType.build();
    }

    private MetadataType buildMessageFilterType() {
        ObjectTypeBuilder objectTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().id("RedeliveryPolicyMessageIdentifier").with((TypeAnnotation)new ExclusiveOptionalsTypeAnnotation(Sets.newHashSet((Object[])new String[]{USE_SECURE_HASH, ID_EXPRESSION}), true));
        BaseTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
        this.addBooleanField(objectTypeBuilder, typeBuilder, USE_SECURE_HASH, "Whether to use a secure hash algorithm to identify a redelivered message", true);
        this.addStringField(objectTypeBuilder, typeBuilder, ID_EXPRESSION, "Defines one or more expressions to use to determine when a message has been redelivered. This property may only be set if useSecureHash is false.", null);
        return objectTypeBuilder.build();
    }
}

