/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.test.dsl;

import io.qameta.allure.Issue;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.util.NameUtils;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.extension.api.test.dsl.BaseXmlDeclarationTestCase;
import org.mule.runtime.extension.api.test.dsl.model.ComplexFieldsType;
import org.mule.runtime.extension.api.test.dsl.model.ImportedContainerType;

@RunWith(value=Parameterized.class)
public class ComponentsXmlDeclarationTestCase
extends BaseXmlDeclarationTestCase {
    private static final String CONNECTION_PROVIDER_SUFFIX = "connection";
    private static final String CONFIGURATION_SUFFIX = "config";
    private static final String COMPLEX_PARAMETER = "complexParameter";
    private static final String GROUPED_COMPLEX_PARAMETER = "groupedComplexParameter";
    private static final String SIMPLE_PARAMETER = "simpleParameter";
    private static final String INLINE_GROUP = "inlineGroup";

    public ComponentsXmlDeclarationTestCase(ParameterRole role) {
        super(role);
    }

    @Before
    public void enrichParameters() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        ParameterModel complexParameterModel = this.mockBehaviourParam(COMPLEX_PARAMETER, ComplexFieldsType.class);
        Mockito.when((Object)this.parameterGroupModel.getParameterModels()).thenReturn(Arrays.asList(this.parameterModel, complexParameterModel));
        ParameterModel simpleParameterModel = this.mockBehaviourParam(SIMPLE_PARAMETER, Integer.class);
        ParameterModel groupedComplexParameterModel = this.mockBehaviourParam(GROUPED_COMPLEX_PARAMETER, ComplexFieldsType.class);
        ParameterGroupModel inlineGroupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)inlineGroupModel.getName()).thenReturn((Object)INLINE_GROUP);
        Mockito.when((Object)inlineGroupModel.isShowInDsl()).thenReturn((Object)true);
        Mockito.when((Object)inlineGroupModel.getParameterModels()).thenReturn(Arrays.asList(simpleParameterModel, groupedComplexParameterModel));
        Mockito.when((Object)this.source.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel, inlineGroupModel));
        Mockito.when((Object)this.operation.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel, inlineGroupModel));
        Mockito.when((Object)this.configuration.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel, inlineGroupModel));
        Mockito.when((Object)this.connectionProvider.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel, inlineGroupModel));
        Stream.of(this.configuration, this.operation, this.connectionProvider, this.source).forEach(model -> {
            Mockito.when((Object)this.connectionProvider.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel, inlineGroupModel));
            Mockito.when((Object)model.getAllParameterModels()).thenReturn(Arrays.asList(this.parameterModel, complexParameterModel, simpleParameterModel, groupedComplexParameterModel));
        });
    }

    @Test
    public void testOperationDeclaration() {
        DslElementSyntax result = this.getSyntaxResolver().resolve((NamedObject)this.operation);
        Assert.assertThat((Object)result.getElementName(), (Matcher)CoreMatchers.is((Object)NameUtils.hyphenize((String)"mockOperation")));
        Assert.assertThat((Object)result.getPrefix(), (Matcher)CoreMatchers.is((Object)"mockns"));
        Assert.assertThat((Object)result.requiresConfig(), (Matcher)CoreMatchers.is((Object)true));
        this.assertTopElementDeclarationIs(false, result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertAttributeDeclaration(false, result);
        this.assertIsWrappedElement(false, result);
        this.assertStringTypeComponentParameter(result);
        this.assertComplexTypeComponentParameter(result);
        this.assertInlineParameterGroup(result);
    }

    @Test
    public void testSourceDeclaration() {
        DslElementSyntax result = this.getSyntaxResolver().resolve((NamedObject)this.source);
        Assert.assertThat((Object)result.getAttributeName(), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)result.getElementName(), (Matcher)CoreMatchers.is((Object)NameUtils.hyphenize((String)"source")));
        Assert.assertThat((Object)result.getPrefix(), (Matcher)CoreMatchers.is((Object)"mockns"));
        Assert.assertThat((Object)result.requiresConfig(), (Matcher)CoreMatchers.is((Object)true));
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
        this.assertStringTypeComponentParameter(result);
        this.assertComplexTypeComponentParameter(result);
        this.assertInlineParameterGroup(result);
    }

    @Test
    public void testConfigurationDeclaration() {
        DslElementSyntax result = this.getSyntaxResolver().resolve((NamedObject)this.configuration);
        Assert.assertThat((Object)result.getAttributeName(), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)result.getElementName(), (Matcher)CoreMatchers.is((Object)"test-config"));
        Assert.assertThat((Object)result.getPrefix(), (Matcher)CoreMatchers.is((Object)"mockns"));
        Assert.assertThat((Object)result.requiresConfig(), (Matcher)CoreMatchers.is((Object)false));
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
        this.assertStringTypeComponentParameter(result);
        this.assertComplexTypeComponentParameter(result);
        this.assertInlineParameterGroup(result);
    }

    @Test
    public void testConfigurationDeclarationWithConfigSuffix() {
        Mockito.when((Object)this.configuration.getName()).thenReturn((Object)"testConfig");
        this.testConfigurationDeclaration();
    }

    @Test
    public void testDefaultConfigurationDeclarationWithConfigSuffix() {
        String defaultName = CONFIGURATION_SUFFIX;
        Mockito.when((Object)this.configuration.getName()).thenReturn((Object)defaultName);
        DslElementSyntax result = this.getSyntaxResolver().resolve((NamedObject)this.configuration);
        Assert.assertThat((Object)result.getElementName(), (Matcher)CoreMatchers.is((Object)defaultName));
    }

    @Test
    public void testConnectionProviderDeclarationWithConnectionSuffix() {
        Mockito.when((Object)this.connectionProvider.getName()).thenReturn((Object)"testConnection");
        this.testConnectionProviderDeclaration();
    }

    @Test
    public void testDefaultConnectionProviderDeclarationWithConnectionSuffix() {
        String defaultName = CONNECTION_PROVIDER_SUFFIX;
        Mockito.when((Object)this.connectionProvider.getName()).thenReturn((Object)defaultName);
        DslElementSyntax result = this.getSyntaxResolver().resolve((NamedObject)this.connectionProvider);
        Assert.assertThat((Object)result.getElementName(), (Matcher)CoreMatchers.is((Object)defaultName));
    }

    @Test
    public void testConnectionProviderDeclaration() {
        DslElementSyntax result = this.getSyntaxResolver().resolve((NamedObject)this.connectionProvider);
        Assert.assertThat((Object)result.getAttributeName(), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)result.getElementName(), (Matcher)CoreMatchers.is((Object)"test-connection"));
        Assert.assertThat((Object)result.getPrefix(), (Matcher)CoreMatchers.is((Object)"mockns"));
        Assert.assertThat((Object)result.requiresConfig(), (Matcher)CoreMatchers.is((Object)false));
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
        this.assertStringTypeComponentParameter(result);
        this.assertComplexTypeComponentParameter(result);
        this.assertInlineParameterGroup(result);
    }

    @Test
    public void connectedOperation() {
        Mockito.when((Object)this.operation.requiresConnection()).thenReturn((Object)true);
        DslElementSyntax result = this.getSyntaxResolver().resolve((NamedObject)this.operation);
        Assert.assertThat((Object)result.requiresConfig(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void importedTypeParameter() {
        Assume.assumeThat((Object)this.role, (Matcher)CoreMatchers.is((Object)ParameterRole.BEHAVIOUR));
        ParameterModel importedTypeParameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)importedTypeParameterModel.getName()).thenReturn((Object)"myCamelCaseName");
        Mockito.when((Object)importedTypeParameterModel.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
        Mockito.when((Object)importedTypeParameterModel.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)importedTypeParameterModel.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)importedTypeParameterModel.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)importedTypeParameterModel.getRole()).thenReturn((Object)this.role);
        Mockito.when((Object)importedTypeParameterModel.getModelProperty(QNameModelProperty.class)).thenReturn(Optional.of(new QNameModelProperty(new QName("http://otherNs", "myCamelCaseName", "otherNs"))));
        MetadataType importedType = this.TYPE_LOADER.load(ImportedContainerType.class);
        Mockito.when((Object)importedTypeParameterModel.getType()).thenReturn((Object)importedType);
        Mockito.when((Object)this.extension.getImportedTypes()).thenReturn(Collections.singleton(new ImportedTypeModel((ObjectType)importedType)));
        DslElementSyntax result = this.getSyntaxResolver().resolve(importedTypeParameterModel);
        Assert.assertThat((Object)((DslElementSyntax)result.getContainedElement("notGlobal").get()).getPrefix(), (Matcher)CoreMatchers.is((Object)"mule"));
        Assert.assertThat((Object)((DslElementSyntax)result.getContainedElement("notGlobal").get()).getNamespace(), (Matcher)CoreMatchers.is((Object)"http://www.mulesoft.org/schema/mule/core"));
        Assert.assertThat((Object)((DslElementSyntax)result.getContainedElement("notGlobal").get()).getElementName(), (Matcher)CoreMatchers.is((Object)"not-global"));
    }

    @Test
    @Issue(value="W-14616115")
    public void attributesWithNamespace() {
        Assume.assumeThat((Object)this.role, (Matcher)CoreMatchers.is((Object)ParameterRole.BEHAVIOUR));
        ParameterModel withNamespaceParameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)withNamespaceParameterModel.getName()).thenReturn((Object)"myCamelCaseName");
        Mockito.when((Object)withNamespaceParameterModel.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
        Mockito.when((Object)withNamespaceParameterModel.getModelProperty(QNameModelProperty.class)).thenReturn(Optional.of(new QNameModelProperty(new QName("http://namespace", "myCamelCaseName_qname", "ns"))));
        Mockito.when((Object)withNamespaceParameterModel.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)withNamespaceParameterModel.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)withNamespaceParameterModel.getRole()).thenReturn((Object)this.role);
        Mockito.when((Object)withNamespaceParameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(Boolean.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(withNamespaceParameterModel);
        Assert.assertThat((Object)result.getAttributeName(), (Matcher)CoreMatchers.is((Object)"myCamelCaseName_qname"));
        Assert.assertThat((Object)result.getNamespace(), (Matcher)CoreMatchers.is((Object)"http://namespace"));
        Assert.assertThat((Object)result.getPrefix(), (Matcher)CoreMatchers.is((Object)"ns"));
    }

    private void assertStringTypeComponentParameter(DslElementSyntax result) {
        this.ifContentParameter(() -> Assert.assertThat((Object)result.getChild("myCamelCaseName").isPresent(), (Matcher)CoreMatchers.is((Object)true)), () -> {
            DslElementSyntax childDsl = this.getAttributeDsl("myCamelCaseName", result);
            this.assertAttributeName("myCamelCaseName", childDsl);
            this.assertParameterChildElementDeclaration(false, childDsl);
            this.assertIsWrappedElement(false, childDsl);
        });
    }

    private void assertInlineParameterGroup(DslElementSyntax result) {
        Assert.assertThat((Object)result.getAttribute(INLINE_GROUP).isPresent(), (Matcher)CoreMatchers.is((Object)false));
        DslElementSyntax inlineDsl = this.getChildFieldDsl(INLINE_GROUP, result);
        Assert.assertThat((Object)inlineDsl.getElementName(), (Matcher)CoreMatchers.is((Object)NameUtils.hyphenize((String)INLINE_GROUP)));
        Assert.assertThat((Object)inlineDsl.getPrefix(), (Matcher)CoreMatchers.is((Object)"mockns"));
        this.assertChildElementDeclarationIs(true, inlineDsl);
        this.assertTopElementDeclarationIs(false, inlineDsl);
        this.assertAttributeDeclaration(false, inlineDsl);
        this.assertIsWrappedElement(false, inlineDsl);
        DslElementSyntax attributeDsl = this.getAttributeDsl(SIMPLE_PARAMETER, inlineDsl);
        Assert.assertThat((Object)result.getChild(SIMPLE_PARAMETER).isPresent(), (Matcher)CoreMatchers.is((Object)false));
        this.assertAttributeName(SIMPLE_PARAMETER, attributeDsl);
        this.assertElementName("", attributeDsl);
        this.assertElementPrefix("", attributeDsl);
        this.assertChildElementDeclarationIs(false, attributeDsl);
        this.assertIsWrappedElement(false, attributeDsl);
        this.assertNoAttributes(attributeDsl);
        this.assertNoChilds(attributeDsl);
        DslElementSyntax complexAttributeDsl = this.getAttributeDsl(GROUPED_COMPLEX_PARAMETER, inlineDsl);
        this.assertAttributeName(GROUPED_COMPLEX_PARAMETER, complexAttributeDsl);
        DslElementSyntax childDsl = this.getChildFieldDsl(GROUPED_COMPLEX_PARAMETER, inlineDsl);
        this.assertComplexTypeDslFields(childDsl);
    }

    private void assertComplexTypeComponentParameter(DslElementSyntax result) {
        DslElementSyntax attributeDsl = this.getAttributeDsl(COMPLEX_PARAMETER, result);
        this.assertAttributeName(COMPLEX_PARAMETER, attributeDsl);
        DslElementSyntax childDsl = this.getChildFieldDsl(COMPLEX_PARAMETER, result);
        this.assertComplexTypeDslFields(childDsl);
    }
}

