/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.test.dsl;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.extension.api.declaration.type.annotation.SubstitutionGroup;
import org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.test.dsl.BaseXmlDeclarationTestCase;
import org.mule.runtime.extension.api.test.dsl.model.AbstractType;
import org.mule.runtime.extension.api.test.dsl.model.ComplexFieldsType;
import org.mule.runtime.extension.api.test.dsl.model.ExtensibleType;
import org.mule.runtime.extension.api.test.dsl.model.GlobalType;
import org.mule.runtime.extension.api.test.dsl.model.InterfaceDeclaration;
import org.mule.runtime.extension.api.test.dsl.model.ListOfAbstracType;
import org.mule.runtime.extension.api.test.dsl.model.NotGlobalType;
import org.mule.runtime.extension.api.test.dsl.model.RecursiveChainA;
import org.mule.runtime.extension.api.test.dsl.model.RecursiveChainB;
import org.mule.runtime.extension.api.test.dsl.model.RecursivePojo;
import org.mule.runtime.extension.api.test.dsl.model.SimpleFieldsType;
import org.mule.runtime.extension.api.test.dsl.model.SubstitutionGroupReferencingType;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;

@RunWith(value=Parameterized.class)
public class TypeXmlDeclarationTestCase
extends BaseXmlDeclarationTestCase {
    public TypeXmlDeclarationTestCase(ParameterRole role) {
        super(role);
    }

    @Test
    public void textField() {
        MetadataType type = this.TYPE_LOADER.load(SimpleFieldsType.class);
        DslElementSyntax typeSyntax = (DslElementSyntax)this.getSyntaxResolver().resolve(type).orElseThrow(() -> new RuntimeException("No dsl declaration found for the given type"));
        DslElementSyntax textFieldSyntax = (DslElementSyntax)typeSyntax.getChild("textField").get();
        this.assertAttributeDeclaration(false, textFieldSyntax);
        Assert.assertThat((Object)textFieldSyntax.getElementName(), (Matcher)CoreMatchers.is((Object)"text-field"));
        Assert.assertThat((Object)textFieldSyntax.getAttributeName(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void testRecursiveTypeAndChain() {
        MetadataType type = this.TYPE_LOADER.load(RecursivePojo.class);
        Optional topDsl = this.getSyntaxResolver().resolve(type);
        Assert.assertThat((String)"Type dsl declaration expected but none applied", (Object)topDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        DslElementSyntax mappedChilds = (DslElementSyntax)((DslElementSyntax)topDsl.get()).getChild("mappedChilds").get();
        this.assertAttributeName("mappedChilds", mappedChilds);
        this.assertElementName("mapped-childs", mappedChilds);
        this.assertChildElementDeclarationIs(true, mappedChilds);
        Assert.assertThat((Object)mappedChilds.getGenerics().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)mappedChilds.getGenerics().containsKey(type), (Matcher)CoreMatchers.is((Object)true));
        type = this.TYPE_LOADER.load(RecursiveChainA.class);
        topDsl = this.getSyntaxResolver().resolve(type);
        Assert.assertThat((String)"Type dsl declaration expected but none applied", (Object)topDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        type = this.TYPE_LOADER.load(RecursiveChainB.class);
        topDsl = this.getSyntaxResolver().resolve(type);
        Assert.assertThat((String)"Type dsl declaration expected but none applied", (Object)topDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testListOfAbstractClassType() {
        MetadataType type = this.TYPE_LOADER.load(ListOfAbstracType.class);
        Mockito.when((Object)this.typeCatalog.containsBaseType((ObjectType)ArgumentMatchers.argThat(objectType -> MetadataTypeUtils.getTypeId((MetadataType)objectType).map(typeId -> AbstractType.class.getName().equals(typeId)).isPresent()))).thenReturn((Object)true);
        Optional topDsl = this.getSyntaxResolver().resolve(type);
        Assert.assertThat((String)"Type dsl declaration expected but none applied", (Object)topDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        DslElementSyntax dslElementSyntax = (DslElementSyntax)topDsl.get();
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)type), dslElementSyntax);
        this.assertChildElementDeclarationIs(true, dslElementSyntax);
        Optional abstractTypes = dslElementSyntax.getChild("abstractTypes");
        Assert.assertThat((String)"Type dsl declaration expected but none applied", (Object)abstractTypes.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((DslElementSyntax)abstractTypes.get()).isWrapped(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)((DslElementSyntax)abstractTypes.get()).getGenerics().size(), (Matcher)CoreMatchers.is((Object)1));
        MetadataType genericType = this.TYPE_LOADER.load(AbstractType.class);
        Assert.assertThat((Object)((DslElementSyntax)abstractTypes.get()).getGenerics().containsKey(genericType), (Matcher)CoreMatchers.is((Object)true));
        this.assertIsWrappedElement(true, (DslElementSyntax)((DslElementSyntax)abstractTypes.get()).getGeneric(genericType).get());
    }

    @Test
    public void testComplexRecursiveType() {
        MetadataType type = this.TYPE_LOADER.load(ComplexFieldsType.class);
        Optional topDsl = this.getSyntaxResolver().resolve(type);
        Assert.assertThat((String)"Type dsl declaration expected but none applied", (Object)topDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)type), (DslElementSyntax)topDsl.get());
        this.assertElementPrefix("mockns", (DslElementSyntax)topDsl.get());
        this.assertChildElementDeclarationIs(true, (DslElementSyntax)topDsl.get());
        this.assertIsWrappedElement(false, (DslElementSyntax)topDsl.get());
        this.assertComplexTypeDslFields((DslElementSyntax)topDsl.get());
    }

    @Test
    public void testNoGlobalType() {
        MetadataType type = this.TYPE_LOADER.load(NotGlobalType.class);
        Optional topDsl = this.getSyntaxResolver().resolve(type);
        Assert.assertThat((String)"Type dsl declaration expected but none applied", (Object)topDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)type), (DslElementSyntax)topDsl.get());
        this.assertElementPrefix("mockns", (DslElementSyntax)topDsl.get());
        this.assertChildElementDeclarationIs(true, (DslElementSyntax)topDsl.get());
        this.assertTopElementDeclarationIs(false, (DslElementSyntax)topDsl.get());
        this.assertIsWrappedElement(false, (DslElementSyntax)topDsl.get());
    }

    @Test
    public void testGlobalType() {
        MetadataType type = this.TYPE_LOADER.load(GlobalType.class);
        Optional topDsl = this.getSyntaxResolver().resolve(type);
        Assert.assertThat((String)"Type dsl declaration expected but none applied", (Object)topDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)type), (DslElementSyntax)topDsl.get());
        this.assertElementPrefix("mockns", (DslElementSyntax)topDsl.get());
        this.assertChildElementDeclarationIs(true, (DslElementSyntax)topDsl.get());
        this.assertTopElementDeclarationIs(true, (DslElementSyntax)topDsl.get());
        this.assertIsWrappedElement(false, (DslElementSyntax)topDsl.get());
    }

    @Test
    public void testAbsentIfNotComplex() {
        MetadataType type = this.TYPE_LOADER.load(String.class);
        Optional topDsl = this.getSyntaxResolver().resolve(type);
        Assert.assertThat((String)"Type dsl declaration not expected but one was found", (Object)topDsl.isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testAbsentIfNotGlobalWrappedNorChild() {
        MetadataType type = this.TYPE_LOADER.load(InterfaceDeclaration.class);
        Optional topDsl = this.getSyntaxResolver().resolve(type);
        Assert.assertThat((String)"Type dsl declaration not expected but one was found", (Object)topDsl.isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testExtensibleImportParameter() {
        ExtensionModel importOriginMock = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        this.mockImportedTypes(importOriginMock, "importExtensionWithXml", ExtensibleType.class);
        Mockito.when((Object)importOriginMock.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setXsdFileName("").setPrefix(NameUtils.defaultNamespace((String)"importExtensionWithXml")).setNamespace("http://www.mulesoft.org/schema/mule/importns").setXsdFileName("").setSchemaLocation("http://www.mulesoft.org/schema/mule/importns/current/mule-import-extension-with-xml.xsd").build());
        MetadataType paramType = this.TYPE_LOADER.load(ExtensibleType.class);
        Mockito.when((Object)this.dslContext.getExtension("importExtensionWithXml")).thenReturn(Optional.of(importOriginMock));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)paramType);
        Optional typeResult = this.getSyntaxResolver().resolve(paramType);
        Assert.assertThat((Object)typeResult.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        this.assertElementPrefix(NameUtils.defaultNamespace((String)"importExtensionWithXml"), (DslElementSyntax)typeResult.get());
        this.assertExtensibleTypeDslStructure((DslElementSyntax)typeResult.get());
    }

    @Test
    public void testSubstitutionGroupReferencingType() {
        MetadataType type = this.TYPE_LOADER.load(SubstitutionGroupReferencingType.class);
        Optional topDsl = this.getSyntaxResolver().resolve(type);
        Optional substitutionGroup = ExtensionMetadataTypeUtils.getSubstitutionGroup((MetadataType)type);
        Assert.assertThat((Object)((SubstitutionGroup)substitutionGroup.get()).getPrefix(), (Matcher)CoreMatchers.is((Object)"someprefix"));
        Assert.assertThat((Object)((SubstitutionGroup)substitutionGroup.get()).getElement(), (Matcher)CoreMatchers.is((Object)"some-element"));
        Assert.assertThat((String)"Type dsl declaration expected but none applied", (Object)topDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)type), (DslElementSyntax)topDsl.get());
        this.assertElementPrefix("mockns", (DslElementSyntax)topDsl.get());
        this.assertChildElementDeclarationIs(true, (DslElementSyntax)topDsl.get());
        this.assertIsWrappedElement(false, (DslElementSyntax)topDsl.get());
    }

    @Test
    public void testFallbackToAliasIfTypeIdAndClassNameNotPresent() {
        ObjectType type = TYPE_BUILDER.objectType().with((TypeAnnotation)new TypeAliasAnnotation("aliasName")).with((TypeAnnotation)new TypeDslAnnotation(true, true, null, null)).build();
        Optional topDsl = this.getSyntaxResolver().resolve((MetadataType)type);
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)type), (DslElementSyntax)topDsl.get());
        this.assertElementPrefix("mockns", (DslElementSyntax)topDsl.get());
    }

    @Test
    public void testTypeWithFieldsFallbackToAlias() {
        ObjectTypeBuilder builder = TYPE_BUILDER.objectType().with((TypeAnnotation)new TypeAliasAnnotation("aliasName")).with((TypeAnnotation)new TypeDslAnnotation(true, true, null, null));
        builder.addField().key("fieldName").value().stringType().defaultValue("fieldValue");
        ObjectType type = builder.build();
        Optional topDsl = this.getSyntaxResolver().resolve((MetadataType)type);
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)type), (DslElementSyntax)topDsl.get());
        this.assertElementPrefix("mockns", (DslElementSyntax)topDsl.get());
        Assert.assertThat((Object)((DslElementSyntax)((DslElementSyntax)topDsl.get()).getAttribute("fieldName").get()).getAttributeName(), (Matcher)CoreMatchers.is((Object)"fieldName"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTypeWithoutNameAliasAndTypeId() {
        ObjectType type = TYPE_BUILDER.objectType().with((TypeAnnotation)new TypeDslAnnotation(true, true, null, null)).build();
        this.getSyntaxResolver().resolve((MetadataType)type);
    }
}

