/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.test.internal.loader.validator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.test.util.tck.ExtensionModelTestUtils;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.property.NoWrapperModelProperty;
import org.mule.runtime.extension.internal.loader.validator.NoWrapperModelValidator;

@RunWith(value=MockitoJUnitRunner.class)
public class NoWrapperModelValidatorTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionModel extensionModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private OperationModel operationModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private SourceModel sourceModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private FunctionModel functionModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ConstructModel constructModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ConnectionProviderModel connectionProviderModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ConfigurationModel configurationModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ParameterGroupModel parameterGroupModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ParameterModel parameterModel;
    private NoWrapperModelValidator noWrapperModelValidator;
    private ProblemsReporter problemsReporter;
    private ClassTypeLoader TYPE_LOADER = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    @Before
    public void setUp() {
        this.noWrapperModelValidator = new NoWrapperModelValidator();
        this.problemsReporter = new ProblemsReporter(this.extensionModel);
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Collections.singletonList(this.operationModel));
        Mockito.when((Object)this.extensionModel.getFunctionModels()).thenReturn(Collections.singletonList(this.functionModel));
        Mockito.when((Object)this.extensionModel.getConfigurationModels()).thenReturn(Collections.singletonList(this.configurationModel));
        Mockito.when((Object)this.configurationModel.getConnectionProviders()).thenReturn(Collections.singletonList(this.connectionProviderModel));
        Mockito.when((Object)this.extensionModel.getConstructModels()).thenReturn(Collections.singletonList(this.constructModel));
        Mockito.when((Object)this.configurationModel.getSourceModels()).thenReturn(Collections.singletonList(this.sourceModel));
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"operationName");
        Mockito.when((Object)this.configurationModel.getName()).thenReturn((Object)"configName");
        Mockito.when((Object)this.parameterGroupModel.getName()).thenReturn((Object)"parameterGroupName");
        Mockito.when((Object)this.parameterModel.getName()).thenReturn((Object)"parameterName");
        Mockito.when((Object)this.sourceModel.getName()).thenReturn((Object)"sourceName");
        Mockito.when((Object)this.connectionProviderModel.getName()).thenReturn((Object)"connectionProviderName");
        Mockito.when((Object)this.parameterGroupModel.getParameterModels()).thenReturn(Collections.singletonList(this.parameterModel));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        Mockito.when((Object)this.operationModel.getParameterGroupModels()).thenReturn(Collections.singletonList(this.parameterGroupModel));
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operationModel, this.sourceModel});
    }

    @Test
    public void nonArrayOrMapParameterWithNoWrapper() {
        Mockito.when((Object)this.parameterModel.getModelProperty(NoWrapperModelProperty.class)).thenReturn(Optional.of(NoWrapperModelProperty.INSTANCE));
        this.validateError("Parameter named parameterName is enriched with the NoWrapperModelProperty. Parameters that are not array types or maps cannot be enriched with the NoWrapperModelProperty.");
    }

    @Test
    public void operationEnrichedWithNoWrapper() {
        Mockito.when((Object)this.operationModel.getModelProperty(NoWrapperModelProperty.class)).thenReturn(Optional.of(NoWrapperModelProperty.INSTANCE));
        this.validateError("Operation named operationName is enriched with the NoWrapperModelProperty. Operations are not allowed to be enriched with it.");
    }

    @Test
    public void sourceEnrichedWithNoWrapper() {
        Mockito.when((Object)this.sourceModel.getModelProperty(NoWrapperModelProperty.class)).thenReturn(Optional.of(NoWrapperModelProperty.INSTANCE));
        this.validateError("Source named sourceName is enriched with the NoWrapperModelProperty. Sources are not allowed to be enriched with it.");
    }

    @Test
    public void configurationEnrichedWithNoWrapper() {
        Mockito.when((Object)this.configurationModel.getModelProperty(NoWrapperModelProperty.class)).thenReturn(Optional.of(NoWrapperModelProperty.INSTANCE));
        this.validateError("Configuration named configName is enriched with the NoWrapperModelProperty. Configurations are not allowed to be enriched with it.");
    }

    @Test
    public void connectionProviderEnrichedWithNoWrapper() {
        Mockito.when((Object)this.connectionProviderModel.getModelProperty(NoWrapperModelProperty.class)).thenReturn(Optional.of(NoWrapperModelProperty.INSTANCE));
        this.validateError("Connection provider named connectionProviderName is enriched with the NoWrapperModelProperty. Connection providers are not allowed to be enriched with it.");
    }

    @Test
    public void parameterGroupEnrichedWithNoWrapper() {
        Mockito.when((Object)this.parameterGroupModel.getModelProperty(NoWrapperModelProperty.class)).thenReturn(Optional.of(NoWrapperModelProperty.INSTANCE));
        this.validateError("Parameter group named parameterGroupName is enriched with the NoWrapperModelProperty. Parameter groups are not allowed to be enriched with it.");
    }

    @Test
    public void ownerCannotBeChainIfNoWrapped() {
        NestedChainModel chainModelMock = (NestedChainModel)Mockito.mock(NestedChainModel.class);
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{chainModelMock});
        ArrayList<NestedChainModel> nestedComponents = new ArrayList<NestedChainModel>();
        nestedComponents.add(chainModelMock);
        NestedComponentModel nestedComponentModel = (NestedComponentModel)Mockito.mock(NestedComponentModel.class);
        Mockito.when((Object)nestedComponentModel.getName()).thenReturn((Object)"innerNestedComponent");
        ArrayList<NestedComponentModel> innerNestedComponents = new ArrayList<NestedComponentModel>();
        innerNestedComponents.add(nestedComponentModel);
        Mockito.when((Object)nestedComponentModel.getModelProperty(NoWrapperModelProperty.class)).thenReturn(Optional.of(NoWrapperModelProperty.INSTANCE));
        Mockito.when((Object)this.operationModel.getNestedComponents()).thenReturn(nestedComponents);
        Mockito.when((Object)chainModelMock.getNestedComponents()).thenReturn(innerNestedComponents);
        this.validateError("Nestable component named innerNestedComponent is enriched with the NoWrapperModelProperty. A component cannot be enriched with the NoWrapperModelProperty if its owner is a Chain Model.");
    }

    @Test
    public void ownerCannotBeNoWrappedIfChildIsNoWrapped() {
        NestedComponentModel nestedComponentModelMock = (NestedComponentModel)Mockito.mock(NestedComponentModel.class);
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{nestedComponentModelMock});
        ArrayList<NestedComponentModel> nestedComponents = new ArrayList<NestedComponentModel>();
        nestedComponents.add(nestedComponentModelMock);
        NestedComponentModel innerNestedComponentModel = (NestedComponentModel)Mockito.mock(NestedComponentModel.class);
        Mockito.when((Object)innerNestedComponentModel.getName()).thenReturn((Object)"innerNestedComponent");
        ArrayList<NestedComponentModel> innerNestedComponents = new ArrayList<NestedComponentModel>();
        innerNestedComponents.add(innerNestedComponentModel);
        Mockito.when((Object)innerNestedComponentModel.getModelProperty(NoWrapperModelProperty.class)).thenReturn(Optional.of(NoWrapperModelProperty.INSTANCE));
        Mockito.when((Object)nestedComponentModelMock.getModelProperty(NoWrapperModelProperty.class)).thenReturn(Optional.of(NoWrapperModelProperty.INSTANCE));
        Mockito.when((Object)this.operationModel.getNestedComponents()).thenReturn(nestedComponents);
        Mockito.when((Object)nestedComponentModelMock.getNestedComponents()).thenReturn(innerNestedComponents);
        this.validateError("Nestable component named innerNestedComponent is enriched with the NoWrapperModelProperty. Its owner is also enriched with the NoWrapperModelProperty. The owner and its child cannot be both enriched with it.");
    }

    @Test
    public void noWrappedElementCannotHaveParameters() {
        NestedComponentModel nestedComponentModelMock = (NestedComponentModel)Mockito.mock(NestedComponentModel.class);
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{nestedComponentModelMock});
        ArrayList<NestedComponentModel> nestedComponents = new ArrayList<NestedComponentModel>();
        nestedComponents.add(nestedComponentModelMock);
        NestedComponentModel innerNestedComponentModel = (NestedComponentModel)Mockito.mock(NestedComponentModel.class);
        Mockito.when((Object)innerNestedComponentModel.getName()).thenReturn((Object)"innerNestedComponent");
        ArrayList<NestedComponentModel> innerNestedComponents = new ArrayList<NestedComponentModel>();
        innerNestedComponents.add(innerNestedComponentModel);
        Mockito.when((Object)innerNestedComponentModel.getModelProperty(NoWrapperModelProperty.class)).thenReturn(Optional.of(NoWrapperModelProperty.INSTANCE));
        Mockito.when((Object)innerNestedComponentModel.getAllParameterModels()).thenReturn(Collections.singletonList(this.parameterModel));
        Mockito.when((Object)this.operationModel.getNestedComponents()).thenReturn(nestedComponents);
        Mockito.when((Object)nestedComponentModelMock.getNestedComponents()).thenReturn(innerNestedComponents);
        this.validateError("Nestable component named innerNestedComponent is enriched with the NoWrapperModelProperty. A component cannot be enriched with the NoWrapperModelProperty and have parameters.");
    }

    @Test
    public void ownerCanOnlyHaveOneNoWrappedChainAsChild() {
        NestedComponentModel chainModelMock = (NestedComponentModel)Mockito.mock(NestedComponentModel.class);
        Mockito.when((Object)chainModelMock.getName()).thenReturn((Object)"nestedComponent");
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{chainModelMock});
        ArrayList<NestedComponentModel> nestedComponents = new ArrayList<NestedComponentModel>();
        nestedComponents.add(chainModelMock);
        NestedChainModel nestedChainModel = (NestedChainModel)Mockito.mock(NestedChainModel.class);
        Mockito.when((Object)nestedChainModel.getName()).thenReturn((Object)"nestedChain");
        NestedChainModel otherNestedChainModel = (NestedChainModel)Mockito.mock(NestedChainModel.class);
        Mockito.when((Object)otherNestedChainModel.getName()).thenReturn((Object)"otherNestedChain");
        ArrayList<NestedChainModel> innerChainComponents = new ArrayList<NestedChainModel>();
        innerChainComponents.add(nestedChainModel);
        innerChainComponents.add(otherNestedChainModel);
        Mockito.when((Object)nestedChainModel.getModelProperty(NoWrapperModelProperty.class)).thenReturn(Optional.of(NoWrapperModelProperty.INSTANCE));
        Mockito.when((Object)otherNestedChainModel.getModelProperty(NoWrapperModelProperty.class)).thenReturn(Optional.of(NoWrapperModelProperty.INSTANCE));
        Mockito.when((Object)this.operationModel.getNestedComponents()).thenReturn(nestedComponents);
        Mockito.when((Object)chainModelMock.getNestedComponents()).thenReturn(innerChainComponents);
        this.validateError("Component named nestedComponent has more than one nested chain enriched with the NoWrapperModelProperty [nestedChain, otherNestedChain]. Only one chain child can be enriched with it.");
    }

    private void validateError(String errorMessage) {
        this.noWrapperModelValidator.validate(this.extensionModel, this.problemsReporter);
        MatcherAssert.assertThat((Object)this.problemsReporter.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.problemsReporter.getErrors(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((Problem)this.problemsReporter.getErrors().get(0)).getMessage(), (Matcher)Matchers.containsString((String)errorMessage));
    }
}

