/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.Optional;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.IdempotentDeclarationEnricherWalkDelegate;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.api.property.BackPressureStrategyModelProperty;
import org.mule.runtime.extension.api.runtime.source.BackPressureMode;

public class BackPressureDeclarationEnricher
implements WalkingDeclarationEnricher {
    @Override
    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(final ExtensionLoadingContext extensionLoadingContext) {
        return Optional.of(new IdempotentDeclarationEnricherWalkDelegate(){
            final ExtensionDeclaration extensionDeclaration;
            {
                this.extensionDeclaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
            }

            @Override
            protected void onSource(SourceDeclaration sourceDeclaration) {
                Optional backPressureStrategyModelProperty = sourceDeclaration.getModelProperty(BackPressureStrategyModelProperty.class);
                if (backPressureStrategyModelProperty.isPresent() && ((BackPressureStrategyModelProperty)backPressureStrategyModelProperty.get()).getSupportedModes().size() > 1) {
                    BackPressureDeclarationEnricher.this.addBackPressureParameter(this.extensionDeclaration, sourceDeclaration, (BackPressureStrategyModelProperty)backPressureStrategyModelProperty.get());
                }
            }
        });
    }

    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    private void addBackPressureParameter(ExtensionDeclaration extensionDeclaration, SourceDeclaration sourceDeclaration, BackPressureStrategyModelProperty property) {
        ParameterDeclaration parameter = new ParameterDeclaration("onCapacityOverload");
        parameter.setDescription("Strategy that the runtime will apply when the flow receives more messages than it has the capacity to handle");
        parameter.setRequired(false);
        parameter.setDefaultValue((Object)property.getDefaultMode());
        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
        DefaultStringType type = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().id(String.format("%s-%s-backPressureStrategy", extensionDeclaration.getName(), sourceDeclaration.getName())).with((TypeAnnotation)new EnumAnnotation((Object[])((String[])property.getSupportedModes().stream().map(Enum::name).toArray(String[]::new)))).with((TypeAnnotation)new ClassInformationAnnotation(BackPressureMode.class)).build();
        parameter.setType((MetadataType)type, false);
        sourceDeclaration.getParameterGroup("General").addParameter(parameter);
    }
}

