/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.test.declaration.type.annotation;

import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.extension.api.declaration.type.annotation.SubstitutionGroup;

public class SubstitutionGroupTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testEmptyConstructor() {
        SubstitutionGroup sg = new SubstitutionGroup();
        Assert.assertTrue((boolean)StringUtils.isEmpty((CharSequence)sg.getPrefix()));
        Assert.assertTrue((boolean)StringUtils.isEmpty((CharSequence)sg.getElement()));
    }

    @Test
    public void testConstructorWithEmptyPrefixFails() {
        this.expectedException.expect(IllegalArgumentException.class);
        SubstitutionGroup sg = new SubstitutionGroup("", "some-element");
    }

    @Test
    public void testConstructorWithEmptyElementFails() {
        this.expectedException.expect(IllegalArgumentException.class);
        SubstitutionGroup sg = new SubstitutionGroup("someprefix", "");
    }

    @Test
    public void testConstructorWithEmptyArgumentsFails() {
        this.expectedException.expect(IllegalArgumentException.class);
        SubstitutionGroup sg = new SubstitutionGroup("", "");
    }

    @Test
    public void testConstructorWithArguments() {
        String prefix = "someprefix";
        String element = "some-element";
        SubstitutionGroup sg = new SubstitutionGroup(prefix, element);
        Assert.assertEquals((Object)prefix, (Object)sg.getPrefix());
        Assert.assertEquals((Object)element, (Object)sg.getElement());
    }

    @Test
    public void testConstructorFromStringFailsWithWrongFormat() {
        this.expectedException.expect(IllegalArgumentException.class);
        SubstitutionGroup sg = new SubstitutionGroup("prefix+some-element");
    }

    @Test
    public void testConstructorFromStringFailsWithNoPrefix() {
        this.expectedException.expect(IllegalArgumentException.class);
        SubstitutionGroup sg = new SubstitutionGroup(":some-element");
    }

    @Test
    public void testConstructorFromStringFailsWithNoElement() {
        this.expectedException.expect(IllegalArgumentException.class);
        SubstitutionGroup sg = new SubstitutionGroup("prefix:");
    }

    @Test
    public void testConstructorFromString() {
        SubstitutionGroup sg = new SubstitutionGroup("prefix:some-element");
        Assert.assertEquals((Object)"prefix", (Object)sg.getPrefix());
        Assert.assertEquals((Object)"some-element", (Object)sg.getElement());
    }

    @Test
    public void testConstructorWithStringWithSpacesWorks() {
        SubstitutionGroup sg = new SubstitutionGroup("   prefix:some-element   ");
        Assert.assertEquals((Object)"prefix", (Object)sg.getPrefix());
        Assert.assertEquals((Object)"some-element", (Object)sg.getElement());
    }

    @Test
    public void testEquals() {
        String prefix = "prefix";
        String element = "element";
        SubstitutionGroup sg1 = new SubstitutionGroup(prefix, element);
        SubstitutionGroup sg2 = new SubstitutionGroup(prefix, element);
        Assert.assertEquals((Object)sg1, (Object)sg2);
        SubstitutionGroup sg3 = new SubstitutionGroup(String.format("%s:%s", prefix, element));
        Assert.assertEquals((Object)sg1, (Object)sg3);
        Assert.assertEquals((Object)sg2, (Object)sg3);
    }

    @Test
    public void testHashCode() {
        String prefix = "prefix";
        String element = "element";
        SubstitutionGroup sg1 = new SubstitutionGroup(prefix, element);
        SubstitutionGroup sg2 = new SubstitutionGroup(prefix, element);
        Assert.assertEquals((long)sg1.hashCode(), (long)sg2.hashCode());
        SubstitutionGroup sg3 = new SubstitutionGroup(String.format("%s:%s", prefix, element));
        Assert.assertEquals((long)sg1.hashCode(), (long)sg3.hashCode());
        Assert.assertEquals((long)sg2.hashCode(), (long)sg3.hashCode());
    }
}

