/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.test.internal.loader.util;

import java.lang.reflect.Field;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.internal.loader.util.JavaParserUtils;
import org.mule.sdk.api.annotation.param.ExclusiveOptionals;

public class JavaParserUtilsTestCase {
    @Test
    public void isConfigOverride() throws Exception {
        Field fieldWithSdkConfigOverride = WithConfigOverride.class.getDeclaredField("fieldWithSdkConfigOverride");
        Field fieldWithLegacyConfigOverride = WithConfigOverride.class.getDeclaredField("fieldWithLegacyConfigOverride");
        Field noConfigOverride = WithConfigOverride.class.getDeclaredField("noConfigOverride");
        MatcherAssert.assertThat((Object)JavaParserUtils.isConfigOverride((Field)fieldWithSdkConfigOverride), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)JavaParserUtils.isConfigOverride((Field)fieldWithLegacyConfigOverride), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)JavaParserUtils.isConfigOverride((Field)noConfigOverride), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void isExclusiveOptional() throws Exception {
        Field pojoWithSdkExclusiveOptional = MyParameterGroup.class.getDeclaredField("pojoWithSdkExclusiveOptional");
        Field pojoWithLegacyExclusiveOptional = MyParameterGroup.class.getDeclaredField("pojoWithLegacyExclusiveOptional");
        MatcherAssert.assertThat((Object)((Boolean)JavaParserUtils.getExclusiveOptionalsIsOneRequired(pojoWithSdkExclusiveOptional.getType()).get()), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((Boolean)JavaParserUtils.getExclusiveOptionalsIsOneRequired(pojoWithLegacyExclusiveOptional.getType()).get()), (Matcher)CoreMatchers.is((Object)true));
    }

    private static class WithConfigOverride {
        @org.mule.sdk.api.annotation.param.ConfigOverride
        private Object fieldWithSdkConfigOverride;
        @ConfigOverride
        private Object fieldWithLegacyConfigOverride;
        private Object noConfigOverride;

        private WithConfigOverride() {
        }
    }

    private static class MyParameterGroup {
        PojoWithSdkExclusiveOptional pojoWithSdkExclusiveOptional;
        PojoWithLegacyExclusiveOptional pojoWithLegacyExclusiveOptional;

        private MyParameterGroup() {
        }
    }

    @org.mule.runtime.extension.api.annotation.param.ExclusiveOptionals(isOneRequired=true)
    private static class PojoWithLegacyExclusiveOptional {
        private PojoWithLegacyExclusiveOptional() {
        }
    }

    @ExclusiveOptionals(isOneRequired=true)
    private static class PojoWithSdkExclusiveOptional {
        private PojoWithSdkExclusiveOptional() {
        }
    }
}

