/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.meta.model.stereotype.ImmutableStereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.enricher.ExtensionsErrorsDeclarationEnricher;
import org.mule.sdk.api.stereotype.MuleStereotypes;

@RunWith(value=MockitoJUnitRunner.class)
public class ExtensionsErrorsDeclarationEnricherTestCase {
    private static final String NAMESPACE = "TEST";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionLoadingContext extensionLoadingContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclarer declarer;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclaration extensionDeclaration;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private OperationDeclaration operationDeclaration;
    private ExtensionsErrorsDeclarationEnricher enricher = new ExtensionsErrorsDeclarationEnricher();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionLoadingContext.getExtensionDeclarer()).thenReturn((Object)this.declarer);
        Mockito.when((Object)this.declarer.getDeclaration()).thenReturn((Object)this.extensionDeclaration);
        Mockito.when((Object)this.extensionDeclaration.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setNamespace(NAMESPACE).setPrefix(NAMESPACE).build());
        Mockito.when((Object)this.extensionDeclaration.getOperations()).thenReturn(Arrays.asList(this.operationDeclaration));
    }

    @Test
    public void addValidationErrorOnOperationAndExtension() {
        this.setValidatorStereotype(this.operationDeclaration);
        this.enricher.enrich(this.extensionLoadingContext);
        ArgumentCaptor errorCaptor = ArgumentCaptor.forClass(ErrorModel.class);
        ((OperationDeclaration)Mockito.verify((Object)this.operationDeclaration)).addErrorModel((ErrorModel)errorCaptor.capture());
        ErrorModel operationError = (ErrorModel)errorCaptor.getValue();
        Assert.assertThat((Object)operationError, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        errorCaptor = ArgumentCaptor.forClass(ErrorModel.class);
        ((ExtensionDeclaration)Mockito.verify((Object)this.extensionDeclaration)).addErrorModel((ErrorModel)errorCaptor.capture());
        ErrorModel extensionError = (ErrorModel)errorCaptor.getValue();
        Assert.assertThat((Object)extensionError, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)operationError)));
        Assert.assertThat((Object)extensionError.getNamespace(), (Matcher)CoreMatchers.equalTo((Object)NAMESPACE));
        Assert.assertThat((Object)extensionError.getType(), (Matcher)CoreMatchers.equalTo((Object)org.mule.sdk.api.error.MuleErrors.VALIDATION.getType()));
        ErrorModel errorParent = (ErrorModel)extensionError.getParent().get();
        Assert.assertThat((Object)errorParent.getType(), (Matcher)CoreMatchers.equalTo((Object)org.mule.sdk.api.error.MuleErrors.VALIDATION.getType()));
        Assert.assertThat((Object)errorParent.getNamespace(), (Matcher)CoreMatchers.equalTo((Object)"MULE"));
    }

    @Test
    public void reuseValidationError() {
        ErrorModel validationError = this.buildValidationError();
        Mockito.when((Object)this.extensionDeclaration.getErrorModels()).thenReturn(Collections.singleton(validationError));
        this.setValidatorStereotype(this.operationDeclaration);
        this.enricher.enrich(this.extensionLoadingContext);
        ArgumentCaptor errorCaptor = ArgumentCaptor.forClass(ErrorModel.class);
        ((OperationDeclaration)Mockito.verify((Object)this.operationDeclaration)).addErrorModel((ErrorModel)errorCaptor.capture());
        ErrorModel operationError = (ErrorModel)errorCaptor.getValue();
        Assert.assertThat((Object)operationError, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)validationError)));
        this.assertNoErrorAdded(this.extensionDeclaration);
    }

    @Test
    public void validationErrorPresent() {
        this.setValidatorStereotype(this.operationDeclaration);
        ErrorModel validationError = this.buildValidationError();
        Mockito.when((Object)this.operationDeclaration.getErrorModels()).thenReturn(Collections.singleton(validationError));
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertNoErrorAdded(this.extensionDeclaration, new ComponentDeclaration[]{this.operationDeclaration});
    }

    @Test
    public void doNotAddValidationErrorOnNonValidatorOperation() {
        Mockito.when((Object)this.operationDeclaration.getStereotype()).thenReturn((Object)new ImmutableStereotypeModel("PEPITA", "PISTOLERA", null));
        this.enricher.enrich(this.extensionLoadingContext);
        this.assertNoErrorAdded(this.extensionDeclaration, new ComponentDeclaration[]{this.operationDeclaration});
    }

    private void assertNoErrorAdded(ExtensionDeclaration extensionDeclaration) {
        ((ExtensionDeclaration)Mockito.verify((Object)extensionDeclaration, (VerificationMode)Mockito.never())).addErrorModel((ErrorModel)ArgumentMatchers.any());
    }

    private void assertNoErrorAdded(ExtensionDeclaration extensionDeclaration, ComponentDeclaration ... components) {
        this.assertNoErrorAdded(extensionDeclaration);
        for (ComponentDeclaration component : components) {
            ((ComponentDeclaration)Mockito.verify((Object)component, (VerificationMode)Mockito.never())).addErrorModel((ErrorModel)ArgumentMatchers.any());
        }
    }

    private ErrorModel buildValidationError() {
        return ErrorModelBuilder.newError((String)org.mule.sdk.api.error.MuleErrors.VALIDATION.getType(), (String)NAMESPACE).withParent(ErrorModelBuilder.newError((String)MuleErrors.VALIDATION.getType(), (String)"MULE").build()).build();
    }

    private void setValidatorStereotype(OperationDeclaration operationDeclaration) {
        Mockito.when((Object)operationDeclaration.getStereotype()).thenReturn((Object)StereotypeModelBuilder.newStereotype((String)MuleStereotypes.VALIDATOR.getType(), (String)NAMESPACE).withParent(MuleStereotypes.VALIDATOR).build());
    }
}

