/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.util;

import java.io.InputStream;
import java.io.Serializable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;

public class ExtenionMetadataTypeUtilsTestCase {
    private ClassTypeLoader typeLoader;

    @Before
    public void setUp() throws Exception {
        this.typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    }

    @Test
    public void isReferableTypeForNonClassBaseTypes() {
        DefaultStringType type = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build();
        MatcherAssert.assertThat((Object)ExtensionMetadataTypeUtils.isReferableType((MetadataType)type), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void isReferableTypeInputStream() {
        MatcherAssert.assertThat((Object)ExtensionMetadataTypeUtils.isReferableType((MetadataType)this.typeLoader.load(InputStream.class)), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void isReferableTypeObject() {
        MatcherAssert.assertThat((Object)ExtensionMetadataTypeUtils.isReferableType((MetadataType)this.typeLoader.load(Object.class)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void isReferableTypeSerializable() {
        MatcherAssert.assertThat((Object)ExtensionMetadataTypeUtils.isReferableType((MetadataType)this.typeLoader.load(Serializable.class)), (Matcher)Matchers.is((Object)true));
    }
}

