/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader;

import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultExtensionLoadingContextTestCase {
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private ExtensionDeclarer descriptor;
    private ExtensionLoadingContext context;

    @Before
    public void before() {
        this.descriptor = new ExtensionDeclarer();
        this.context = new DefaultExtensionLoadingContext(this.descriptor, this.getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet()));
        this.context.addParameter(KEY, (Object)VALUE);
    }

    @Test
    public void getDeclarationDescriptor() {
        Assert.assertThat((Object)this.descriptor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.context.getExtensionDeclarer())));
    }

    @Test
    public void getParameter() {
        Assert.assertThat(this.context.getParameter(KEY).get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)VALUE)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullParameterKey() {
        this.context.addParameter(null, (Object)VALUE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullParameterValue() {
        this.context.addParameter(KEY, null);
    }

    @Test
    public void getClassLoader() {
        Assert.assertThat((Object)this.context.getExtensionClassLoader(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.getClass().getClassLoader())));
    }
}

