/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader;

import java.util.Collections;
import java.util.HashMap;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class BaseExtensionModelFactoryTestCase {
    protected ExtensionModel extensionModel;
    private Consumer<ExtensionDeclarer> declarerConsumer = d -> {};
    protected ExtensionModelLoader loader = new ExtensionModelLoader(){

        public String getId() {
            return "test";
        }

        protected void declareExtension(ExtensionLoadingContext context) {
            BaseExtensionModelFactoryTestCase.this.declarerConsumer.accept(context.getExtensionDeclarer());
        }
    };
    protected ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    private ClassLoader extensionClassLoader = this.getClass().getClassLoader();

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("mule.testingMode", "true");
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty("mule.testingMode");
    }

    @Test
    public void classLoaderModelProperty() {
        ClassLoaderModelProperty classLoaderModelProperty = this.extensionModel.getModelProperty(ClassLoaderModelProperty.class).orElse(null);
        Assert.assertThat((Object)classLoaderModelProperty, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)classLoaderModelProperty.getClassLoader(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.extensionClassLoader)));
    }

    protected final ExtensionModel load() {
        this.extensionModel = this.loader.loadExtensionModel(this.extensionClassLoader, DslResolvingContext.getDefault(Collections.emptySet()), new HashMap());
        return this.extensionModel;
    }

    protected void assertParameter(ParameterModel parameterModel, String name, String description, ExpressionSupport expressionSupport, boolean required, MetadataType metadataType, Class<? extends MetadataType> qualifier, Object defaultValue) {
        Assert.assertThat((Object)parameterModel, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)parameterModel.getName(), (Matcher)CoreMatchers.equalTo((Object)name));
        Assert.assertThat((Object)parameterModel.getDescription(), (Matcher)CoreMatchers.equalTo((Object)description));
        Assert.assertThat((Object)parameterModel.getExpressionSupport(), (Matcher)CoreMatchers.is((Object)expressionSupport));
        Assert.assertThat((Object)parameterModel.isRequired(), (Matcher)CoreMatchers.is((Object)required));
        Assert.assertThat((Object)parameterModel.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(qualifier)));
        if (!parameterModel.getModelProperty(InfrastructureParameterModelProperty.class).isPresent()) {
            Assert.assertThat((Object)JavaTypeUtils.getType((MetadataType)parameterModel.getType()), (Matcher)CoreMatchers.equalTo((Object)JavaTypeUtils.getType((MetadataType)metadataType)));
        }
        if (defaultValue != null) {
            Assert.assertThat((Object)parameterModel.getDefaultValue(), (Matcher)CoreMatchers.equalTo((Object)defaultValue));
        } else {
            Assert.assertThat((Object)parameterModel.getDefaultValue(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        }
    }

    protected void assertDataType(MetadataType metadataType, Class<?> expectedRawType, Class<? extends MetadataType> typeQualifier) {
        Assert.assertThat((Object)metadataType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(typeQualifier)));
        Assert.assertThat((Object)expectedRawType.isAssignableFrom(JavaTypeUtils.getType((MetadataType)metadataType)), (Matcher)CoreMatchers.is((Object)true));
    }

    protected void declare(Consumer<ExtensionDeclarer> consumer) {
        this.declarerConsumer = consumer;
    }
}

