/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader;

import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.NoImplicitModelProperty;
import org.mule.runtime.extension.api.property.SyntheticModelModelProperty;
import org.mule.runtime.extension.internal.loader.enricher.ConfigRefDeclarationEnricher;

@RunWith(value=MockitoJUnitRunner.class)
public class ConfigRefDeclarationEnricherTestCase {
    private static final String CONFIG_REF_NAME = "config-ref";
    @Mock
    private ExtensionLoadingContext extensionLoadingContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclarer extensionDeclarer;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclaration extensionDeclaration;
    private ConfigRefDeclarationEnricher enricher = new ConfigRefDeclarationEnricher();
    private OperationDeclaration operationDeclaration;
    private ConfigurationDeclaration configurationDeclaration;

    @Before
    public void before() {
        this.operationDeclaration = (OperationDeclaration)Mockito.spy((Object)new ExtensionDeclarer().withOperation("testOperation").getDeclaration());
        this.configurationDeclaration = (ConfigurationDeclaration)((ConfigurationDeclarer)Mockito.spy((Object)new ExtensionDeclarer().withConfig("testConfiguration"))).getDeclaration();
        Mockito.when((Object)this.extensionLoadingContext.getExtensionDeclarer()).thenReturn((Object)this.extensionDeclarer);
        Mockito.when((Object)this.extensionDeclarer.getDeclaration()).thenReturn((Object)this.extensionDeclaration);
        Mockito.when((Object)this.extensionDeclaration.getOperations()).thenReturn(Collections.singletonList(this.operationDeclaration));
        Mockito.when((Object)this.extensionDeclaration.getConfigurations()).thenReturn(Collections.singletonList(this.configurationDeclaration));
    }

    @Test
    public void enrichedComponentModelHasConfigRefParameterWhenComponentHasConfigurationAssociated() {
        this.configurationDeclaration.addOperation(this.operationDeclaration);
        this.enricher.enrich(this.extensionLoadingContext);
        ParameterDeclaration parameterDeclaration = (ParameterDeclaration)this.operationDeclaration.getAllParameters().iterator().next();
        Assert.assertThat((Object)parameterDeclaration.getName(), (Matcher)CoreMatchers.equalTo((Object)CONFIG_REF_NAME));
        Assert.assertThat((Object)parameterDeclaration.getModelProperty(SyntheticModelModelProperty.class), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void enrichedComponentModelDoesNotHaveConfigRefParameterWhenComponentDoesNotHaveConfigurationAssociated() {
        this.enricher.enrich(this.extensionLoadingContext);
        Assert.assertThat((Object)this.operationDeclaration.getAllParameters(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void nonImplicitConfigHasRequiredConfigRef() {
        this.configurationDeclaration.addOperation(this.operationDeclaration);
        ParameterDeclaration param = new ParameterDeclaration("required");
        param.setRequired(true);
        this.configurationDeclaration.getParameterGroup("General").addParameter(param);
        this.enricher.enrich(this.extensionLoadingContext);
        ParameterDeclaration configRefDeclaration = (ParameterDeclaration)this.operationDeclaration.getAllParameters().iterator().next();
        Assert.assertThat((Object)configRefDeclaration.getName(), (Matcher)CoreMatchers.equalTo((Object)CONFIG_REF_NAME));
        Assert.assertThat((Object)configRefDeclaration.isRequired(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void implicitConfigHasOptionalConfigRef() {
        this.configurationDeclaration.addOperation(this.operationDeclaration);
        this.configurationDeclaration.getParameterGroup("General").addParameter(new ParameterDeclaration("optional"));
        this.enricher.enrich(this.extensionLoadingContext);
        ParameterDeclaration configRefDeclaration = (ParameterDeclaration)this.operationDeclaration.getAllParameters().iterator().next();
        Assert.assertThat((Object)configRefDeclaration.getName(), (Matcher)CoreMatchers.equalTo((Object)CONFIG_REF_NAME));
        Assert.assertThat((Object)configRefDeclaration.isRequired(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void forcedImplicitConfigHasRequiredConfigRef() {
        this.configurationDeclaration.addOperation(this.operationDeclaration);
        ParameterDeclaration param = new ParameterDeclaration("required");
        param.setRequired(true);
        this.configurationDeclaration.getParameterGroup("General").addParameter(param);
        this.configurationDeclaration.addModelProperty((ModelProperty)new NoImplicitModelProperty());
        this.enricher.enrich(this.extensionLoadingContext);
        ParameterDeclaration configRefDeclaration = (ParameterDeclaration)this.operationDeclaration.getAllParameters().iterator().next();
        Assert.assertThat((Object)configRefDeclaration.getName(), (Matcher)CoreMatchers.equalTo((Object)CONFIG_REF_NAME));
        Assert.assertThat((Object)configRefDeclaration.isRequired(), (Matcher)CoreMatchers.is((Object)true));
    }
}

