/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.tck.TestHttpConnectorDeclarer;
import org.mule.runtime.extension.api.declaration.BaseDeclarationTestCase;

public class ComplexExtensionDeclarationTestCase
extends BaseDeclarationTestCase {
    private TestHttpConnectorDeclarer testDeclarer = new TestHttpConnectorDeclarer();
    private ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)this.testDeclarer.getExtensionDeclarer().getDeclaration();

    @Test
    public void assertDeclaration() {
        Assert.assertThat((Object)this.extensionDeclaration.getName(), (Matcher)CoreMatchers.is((Object)"http"));
        Assert.assertThat((Object)this.extensionDeclaration.getDescription(), (Matcher)CoreMatchers.is((Object)"Http Connector"));
        Assert.assertThat((Object)this.extensionDeclaration.getVersion(), (Matcher)CoreMatchers.is((Object)"1.0"));
        Assert.assertThat((Object)this.extensionDeclaration.getConfigurations(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)this.extensionDeclaration.getVendor(), (Matcher)CoreMatchers.is((Object)"Mulesoft"));
        Assert.assertThat((Object)this.extensionDeclaration.getCategory(), (Matcher)CoreMatchers.is((Object)Category.COMMUNITY));
        Assert.assertThat((Object)this.extensionDeclaration.getOperations(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.extensionDeclaration.getConnectionProviders(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)this.extensionDeclaration.getMessageSources(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void listenerConfig() {
        ConfigurationDeclaration listener = (ConfigurationDeclaration)this.extensionDeclaration.getConfigurations().get(0);
        Assert.assertThat((Object)listener.getName(), (Matcher)CoreMatchers.is((Object)"listener"));
        Assert.assertThat((Object)listener.getDescription(), (Matcher)CoreMatchers.is((Object)"http listener"));
        Assert.assertThat((Object)listener.getOperations(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)listener.getConnectionProviders(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)listener.getMessageSources(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void listenerSource() {
        SourceDeclaration source = (SourceDeclaration)((ConfigurationDeclaration)this.extensionDeclaration.getConfigurations().get(0)).getMessageSources().get(0);
        Assert.assertThat((Object)source.getName(), (Matcher)CoreMatchers.is((Object)"listen"));
        this.assertDataType(source.getOutput().getType(), InputStream.class, BinaryType.class);
        this.assertDataType(source.getOutputAttributes().getType(), Serializable.class, ObjectType.class);
        Assert.assertThat((Object)source.getAllParameters(), (Matcher)Matchers.hasSize((int)1));
        ParameterDeclaration parameter = (ParameterDeclaration)source.getAllParameters().get(0);
        Assert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)"port"));
        Assert.assertThat((Object)parameter.isRequired(), (Matcher)CoreMatchers.is((Object)false));
        this.assertDataType(parameter.getType(), Integer.class, NumberType.class);
    }

    @Test
    public void requesterConfig() {
        ConfigurationDeclaration requester = (ConfigurationDeclaration)this.extensionDeclaration.getConfigurations().get(1);
        Assert.assertThat((Object)requester.getName(), (Matcher)CoreMatchers.is((Object)"requester"));
        Assert.assertThat((Object)requester.getDescription(), (Matcher)CoreMatchers.is((Object)"http requester"));
        Assert.assertThat((Object)requester.getOperations(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)requester.getConnectionProviders(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)requester.getMessageSources(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void requestOperation() {
        OperationDeclaration operation = (OperationDeclaration)((ConfigurationDeclaration)this.extensionDeclaration.getConfigurations().get(1)).getOperations().get(0);
        Assert.assertThat((Object)operation.getName(), (Matcher)CoreMatchers.is((Object)"request"));
        this.assertDataType(operation.getOutput().getType(), InputStream.class, BinaryType.class);
        Assert.assertThat((Object)operation.getAllParameters(), (Matcher)Matchers.hasSize((int)1));
        ParameterDeclaration parameter = (ParameterDeclaration)operation.getAllParameters().get(0);
        Assert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)"path"));
        this.assertDataType(parameter.getType(), String.class, StringType.class);
    }

    @Test
    public void staticResourceOperation() {
        OperationDeclaration operation = (OperationDeclaration)this.extensionDeclaration.getOperations().get(0);
        Assert.assertThat((Object)operation.getName(), (Matcher)CoreMatchers.is((Object)"staticResource"));
        this.assertDataType(operation.getOutput().getType(), InputStream.class, BinaryType.class);
        Assert.assertThat((Object)operation.getAllParameters(), (Matcher)Matchers.hasSize((int)1));
        ParameterDeclaration parameter = (ParameterDeclaration)operation.getAllParameters().get(0);
        Assert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)"path"));
        this.assertDataType(parameter.getType(), String.class, StringType.class);
    }

    @Test
    public void connectionProvider() {
        ConnectionProviderDeclaration provider = (ConnectionProviderDeclaration)((ConfigurationDeclaration)this.extensionDeclaration.getConfigurations().get(1)).getConnectionProviders().get(0);
        Assert.assertThat((Object)provider.getName(), (Matcher)CoreMatchers.is((Object)"requesterProvider"));
        Assert.assertThat((Object)provider.isSupportsConnectivityTesting(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void types() {
        Set types = this.extensionDeclaration.getTypes();
        Assert.assertThat((Object)types, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)types, (Matcher)Matchers.containsInAnyOrder((Object[])new ObjectType[]{TestHttpConnectorDeclarer.COMPLEX_TYPE, TestHttpConnectorDeclarer.ANOTHER_COMPLEX_TYPE}));
    }
}

