/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.extension.api.loader.parser;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.sdk.api.values.ValueProvider;

import java.util.List;
import java.util.Optional;

/**
 * Parses the syntactic definition of a {@link ValueProviderModel} so that the semantics reflected in it can be extracted in a
 * uniform way, regardless of the actual syntax used by the extension developer.
 *
 * @see ParameterModelParser
 * @since 1.10.0
 */
@NoImplement
public interface ValueProviderModelParser extends AdditionalPropertiesModelParser {

  /**
   * @return the id of the associated value provider for this parameter. It should not be repeated among {@link ValueProvider} in
   *         the same extension. Multiple calls to this method must always return the same fixed value.
   */
  String getId();

  /**
   * @return whether the calculated values should be considered as an open or closed set
   */
  boolean isOpen();

  /**
   * @return {@link ActingParameterModelParser}s to represent how to parse parameters of a {@link ValueProvider}.
   */
  List<ActingParameterModelParser> getActingParameterParsers();

  /**
   * @return whether the configuration is required to resolve the values
   */
  boolean requiresConfiguration();

  /**
   * @return whether a connection is required to resolve the values
   */
  boolean requiresConnection();

  /**
   * @return the order of this part in the value in case of a multipart {@link ValueProvider} at the group level.
   */
  Optional<Integer> getPartOrder();

  /**
   * @return a {@link ValueProviderFactory} to represent how the instances of {@link ValueProvider} must be created and
   *         parameterized.
   */
  ValueProviderFactory getValueProviderFactory();
}
