/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.extension.api.loader.parser;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;

/**
 * Creates instances of {@link ValueProvider}.
 *
 * @since 1.10.0
 */
@NoImplement
public interface ValueProviderFactory {

  /**
   * @param context a {@link ValueProviderFactoryContext} with the information needed by the factory.
   * @return a {@link ValueProvider} instance that has all parameters injected.
   * @throws ValueResolvingException if there is an error creating the {@link ValueProvider} instance or resolving some of the
   *                                 injectable parameters
   */
  ValueProvider create(ValueProviderFactoryContext context) throws ValueResolvingException;

}
