/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.api.property.SyntheticModelModelProperty;

public class NamedObjectDeclarationEnricher
implements WalkingDeclarationEnricher {
    private static final MetadataType STRING_TYPE = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build();
    private static final Map<String, Set<String>> BLOCK_LIST;

    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(ExtensionLoadingContext extensionLoadingContext) {
        final Set<String> blockListed = BLOCK_LIST.get(((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration()).getName());
        return Optional.of(new WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate(){

            @Override
            public void onConfiguration(ConfigurationDeclaration declaration) {
                if (blockListed != null && blockListed.contains(declaration.getName())) {
                    return;
                }
                declaration.getDefaultParameterGroup().addParameter(NamedObjectDeclarationEnricher.this.buildNameParameter());
            }
        });
    }

    private ParameterDeclaration buildNameParameter() {
        ParameterDeclaration nameParameter = new ParameterDeclaration("name");
        nameParameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        nameParameter.setParameterRole(ParameterRole.BEHAVIOUR);
        nameParameter.addModelProperty((ModelProperty)new SyntheticModelModelProperty());
        nameParameter.setDescription("The identifier of this element used to reference it in other components");
        nameParameter.setType(STRING_TYPE, false);
        nameParameter.setRequired(true);
        nameParameter.setComponentId(true);
        return nameParameter;
    }

    static {
        SmallMap blockList = new SmallMap();
        blockList.put("cxf", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("wsSecurity", "configuration"))));
        BLOCK_LIST = Collections.unmodifiableMap(blockList);
    }
}

