/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.test.internal.loader.enricher;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OutputDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.extension.api.declaration.type.annotation.ParameterDslAnnotation;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.enricher.ExtensionTypesDeclarationEnricher;

public class ExtensionTypesDeclarationEnricherTestCase {
    @Test
    public void subTypesAndTypesAreSameInstance() {
        ExtensionLoadingContext extensionLoadingContext = (ExtensionLoadingContext)Mockito.mock(ExtensionLoadingContext.class);
        ExtensionDeclarer extensionDeclarer = (ExtensionDeclarer)Mockito.mock(ExtensionDeclarer.class);
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)Mockito.mock(ExtensionDeclaration.class);
        Mockito.when((Object)((ExtensionDeclaration)extensionDeclarer.getDeclaration())).thenReturn((Object)extensionDeclaration);
        Mockito.when((Object)extensionLoadingContext.getExtensionDeclarer()).thenReturn((Object)extensionDeclarer);
        ParameterGroupDeclaration parameterGroupDeclaration = (ParameterGroupDeclaration)Mockito.mock(ParameterGroupDeclaration.class);
        OperationDeclaration operationDeclaration = (OperationDeclaration)Mockito.mock(OperationDeclaration.class);
        Mockito.when((Object)operationDeclaration.getOutput()).thenReturn((Object)((OutputDeclaration)Mockito.mock(OutputDeclaration.class, (Answer)Mockito.RETURNS_DEEP_STUBS)));
        Mockito.when((Object)operationDeclaration.getOutputAttributes()).thenReturn((Object)((OutputDeclaration)Mockito.mock(OutputDeclaration.class, (Answer)Mockito.RETURNS_DEEP_STUBS)));
        Mockito.when((Object)operationDeclaration.getParameterGroups()).thenReturn(Collections.singletonList(parameterGroupDeclaration));
        Mockito.when((Object)extensionDeclaration.getOperations()).thenReturn(Collections.singletonList(operationDeclaration));
        ObjectFieldType paramTypeField = new ObjectFieldTypeBuilder(new MetadataFormat("label", "id", new String[0])).key("key").value((MetadataType)new ObjectTypeBuilder(new MetadataFormat("fieldLabel", "fieldKey", new String[0])).build()).build();
        HashMap<Class<ClassInformationAnnotation>, Object> typeAnnotations = new HashMap<Class<ClassInformationAnnotation>, Object>();
        typeAnnotations.put(TypeIdAnnotation.class, new TypeIdAnnotation("org.mule.test.SomeClass"));
        typeAnnotations.put(ParameterDslAnnotation.class, new ParameterDslAnnotation(false, false));
        typeAnnotations.put(ClassInformationAnnotation.class, new ClassInformationAnnotation("org.mule.test.SomeClass", true, false, true, false, false, Collections.emptyList(), null, Collections.emptyList(), false));
        DefaultObjectType typeA = new DefaultObjectType(Collections.singletonList(paramTypeField), true, null, null, typeAnnotations);
        DefaultObjectType typeB = new DefaultObjectType(Collections.singletonList(paramTypeField), true, null, null, typeAnnotations);
        DefaultObjectType typeC = new DefaultObjectType(Collections.singletonList(paramTypeField), true, null, null, typeAnnotations);
        ParameterDeclaration someParam = new ParameterDeclaration("someParam");
        someParam.setType((MetadataType)typeA, false);
        Mockito.when((Object)parameterGroupDeclaration.getParameters()).thenReturn(Collections.singletonList(someParam));
        Mockito.when((Object)operationDeclaration.getAllParameters()).thenReturn(Collections.singletonList(someParam));
        HashSet<SubTypesModel> subTypes = new HashSet<SubTypesModel>();
        subTypes.add(new SubTypesModel((MetadataType)typeB, Collections.singleton(typeC)));
        Mockito.when((Object)extensionDeclaration.getSubTypes()).thenReturn(subTypes);
        HashSet extensionTypes = new HashSet();
        Mockito.when((Object)extensionDeclarer.withType((ObjectType)Mockito.any())).thenAnswer(inv -> {
            ObjectType newType = (ObjectType)inv.getArgument(0);
            extensionTypes.add(newType);
            return extensionDeclarer;
        });
        new ExtensionTypesDeclarationEnricher().enrich(extensionLoadingContext);
        Assert.assertThat((String)"The type and subtypes are not normalized.", extensionTypes, (Matcher)Matchers.hasItem((Matcher)Matchers.sameInstance((Object)typeB)));
    }
}

