/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.extension.api.loader.parser;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.sdk.api.data.sample.SampleDataProvider;

import java.util.Optional;

/**
 * Parses the syntactic definition of a parameter of a {@link ValueProvider} or {@link SampleDataProvider} so that the semantics
 * reflected in it can be extracted in a uniform way, regardless of the actual syntax used by the extension developer.
 *
 * @since 1.10.0
 */
@NoImplement
public interface ActingParameterModelParser {

  /**
   * @return The name of the parameter in the {@link ValueProvider} or {@link SampleDataProvider}.
   */
  String getParameterName();

  /**
   * @return whether the parameter is required in order to resolve values.
   */
  boolean isRequired();

  /**
   * Gets the expression used to get the acting part of the component whose value is taken for the provider acting parameter. This
   * is only needed when the {@link ValueProvider} or {@link SampleDataProvider} is defined over a complex object.
   *
   * @return the expression used to extract the value of the acting parameter.
   */
  Optional<String> getExtractionExpression();
}
