/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence.test;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.api.declaration.type.annotation.ExtensibleTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ParameterDslAnnotation;
import org.mule.runtime.extension.api.model.ImmutableExtensionModel;
import org.mule.runtime.extension.api.model.connection.ImmutableConnectionProviderModel;
import org.mule.runtime.extension.api.persistence.test.BasePersistenceTestCase;
import org.mule.runtime.extension.api.test.dsl.model.ComplexFieldsType;

public class ExtensionModelPersistenceTestCase
extends BasePersistenceTestCase {
    @Test
    public void nonExternalizableModelsAreNotSerialized() {
        MatcherAssert.assertThat((Object)this.getCarOperation.getModelProperties().contains(this.nonExternalizableModelProperty), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.getCarOperation.getModelProperties().size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)this.operationModelProperties.has(BasePersistenceTestCase.NonExternalizableModelProperty.class.getName()), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.operationModelProperties.entrySet().size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void operationTypeCorrectlyDeserialized() {
        OperationModel operation = (OperationModel)this.deserializedExtensionModel.getOperationModel("getCar").get();
        ParameterModel complexParameter = operation.getAllParameterModels().stream().filter(p -> p.getName().equals("complex")).findFirst().get();
        this.assertComplexParameter(complexParameter);
    }

    @Test
    public void deprecationCorrectlyDeserialized() {
        OperationModel operation = (OperationModel)this.deserializedExtensionModel.getOperationModel("getCar").get();
        ParameterModel parameterModel = (ParameterModel)operation.getAllParameterModels().get(0);
        Assert.assertTrue((boolean)operation.getDeprecationModel().isPresent());
        MatcherAssert.assertThat((Object)((DeprecationModel)operation.getDeprecationModel().get()).getMessage(), (Matcher)Is.is((Object)"This operation is deprecated"));
        MatcherAssert.assertThat((Object)((DeprecationModel)operation.getDeprecationModel().get()).getDeprecatedSince(), (Matcher)Is.is((Object)"1.3.0"));
        Assert.assertTrue((boolean)((DeprecationModel)operation.getDeprecationModel().get()).getToRemoveIn().isPresent());
        MatcherAssert.assertThat((Object)((String)((DeprecationModel)operation.getDeprecationModel().get()).getToRemoveIn().get()), (Matcher)Is.is((Object)"2.0.0"));
        Assert.assertTrue((boolean)parameterModel.getDeprecationModel().isPresent());
        MatcherAssert.assertThat((Object)((DeprecationModel)parameterModel.getDeprecationModel().get()).getMessage(), (Matcher)Is.is((Object)"This is deprecated"));
        MatcherAssert.assertThat((Object)((DeprecationModel)parameterModel.getDeprecationModel().get()).getDeprecatedSince(), (Matcher)Is.is((Object)"1.3.0"));
        Assert.assertFalse((boolean)((DeprecationModel)parameterModel.getDeprecationModel().get()).getToRemoveIn().isPresent());
    }

    @Test
    public void messageSourceCorrectlyDeserialized() {
        SourceModel sourceModel = (SourceModel)this.deserializedExtensionModel.getSourceModel("Source").get();
        MatcherAssert.assertThat((Object)sourceModel.getAllParameterModels().size(), (Matcher)Is.is((Object)3));
        ParameterModel complexParameter = sourceModel.getAllParameterModels().stream().filter(p -> p.getName().equals("complex")).findFirst().get();
        this.assertComplexParameter(complexParameter);
        MatcherAssert.assertThat((Object)sourceModel.getSuccessCallback().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)sourceModel.getErrorCallback().isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void runtimeModelsAreDeserializedIntoNonRuntimeModels() {
        MatcherAssert.assertThat((Object)this.deserializedExtensionModel, (Matcher)IsInstanceOf.instanceOf(ImmutableExtensionModel.class));
        MatcherAssert.assertThat((Object)((ConnectionProviderModel)this.deserializedExtensionModel.getConnectionProviders().get(0)), (Matcher)IsInstanceOf.instanceOf(ImmutableConnectionProviderModel.class));
    }

    @Test
    public void validateJsonStructure() throws IOException {
        String serializedModel = this.extensionModelJsonSerializer.serialize(this.originalExtensionModel);
        this.assertSerializedJson(serializedModel, "/extension/serialized-extension-model.json");
    }

    @Test
    public void validateJsonListStructure() throws IOException {
        String serializedList = this.extensionModelJsonSerializer.serializeList(this.extensionModelList);
        this.assertSerializedJson(serializedList, "/extension/list-of-serialized-extension-model.json");
    }

    @Test
    public void validateJsonStructureWithoutOccurencesInNestedElements() throws IOException {
        ExtensionModel extensionModel = this.extensionModelJsonSerializer.deserialize(this.getResourceAsString("/extension/serialized-extension-model-without-nested-occurs.json"));
        String serializedModel = this.extensionModelJsonSerializer.serialize(extensionModel);
        this.assertSerializedJson(serializedModel, "/extension/serialized-extension-model.json", false);
    }

    @Test
    public void validateCustomTypeAnnotations() throws IOException {
        MetadataType complexType = ((ParameterModel)((OperationModel)this.deserializedExtensionModel.getOperationModels().get(0)).getAllParameterModels().get(1)).getType();
        MatcherAssert.assertThat((Object)complexType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        MatcherAssert.assertThat((Object)complexType.getAnnotation(TypeAliasAnnotation.class).isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((TypeAliasAnnotation)complexType.getAnnotation(TypeAliasAnnotation.class).get()).getValue(), (Matcher)Is.is((Object)"complex-alias"));
        ArrayType extensibleTypeList = (ArrayType)((ObjectFieldType)((ObjectType)complexType).getFieldByName("extensibleTypeList").get()).getValue();
        MatcherAssert.assertThat((Object)extensibleTypeList.getType().getAnnotation(ExtensibleTypeAnnotation.class).isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((TypeAliasAnnotation)extensibleTypeList.getType().getAnnotation(TypeAliasAnnotation.class).get()).getValue(), (Matcher)Is.is((Object)"aliasedExtensible"));
        ObjectType simplePojo = (ObjectType)((ObjectFieldType)((ObjectType)complexType).getFieldByName("simplePojo").get()).getValue();
        MatcherAssert.assertThat((Object)((ParameterDslAnnotation)((ObjectFieldType)simplePojo.getFieldByName("sampleString").get()).getAnnotation(ParameterDslAnnotation.class).get()).allowsReferences(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void enrichedTypesAreSerializated() throws IOException {
        Set<String> typesSet = this.getExtensionTypeIds(this.serializedExtensionModel.getAsJsonObject());
        MatcherAssert.assertThat(typesSet, (Matcher)IsCollectionContaining.hasItem((Matcher)CoreMatchers.containsString((String)BasePersistenceTestCase.ExportedClass.class.getSimpleName())));
        MatcherAssert.assertThat(typesSet, (Matcher)Matchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)CoreMatchers.containsString((String)Object.class.getSimpleName()))));
        MatcherAssert.assertThat(typesSet, (Matcher)Matchers.not((Matcher)IsCollectionContaining.hasItem((Matcher)CoreMatchers.containsString((String)ComplexFieldsType.class.getSimpleName()))));
        Set types = this.deserializedExtensionModel.getTypes();
        MatcherAssert.assertThat((Object)types, (Matcher)IsCollectionContaining.hasItem((Object)this.exportedType));
    }

    @Test
    public void assertDeserializationOfExtensionModelWithNoTypes() throws IOException {
        String serializedExtensionModelWithNoTypes = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/extension/serialized-extension-model-no-catalog.json"));
        ExtensionModel deserializedModel = this.extensionModelJsonSerializer.deserialize(serializedExtensionModelWithNoTypes);
        String serializedModel = this.extensionModelJsonSerializer.serialize(deserializedModel);
        this.assertSerializedJson(serializedModel, "/extension/serialized-extension-model-no-catalog.json", false);
    }

    @Test
    public void operationMinMuleVersionCorrectlyDeserialized() {
        OperationModel operation = (OperationModel)this.deserializedExtensionModel.getOperationModel("getCar").get();
        MatcherAssert.assertThat((Object)operation.getMinMuleVersion(), (Matcher)Is.is((Object)this.getCarOperation.getMinMuleVersion()));
    }

    @Test
    public void connectionProviderMinMuleVersionCorrectlyDeserialized() {
        ConnectionProviderModel deserializedConnectionProvider = (ConnectionProviderModel)this.deserializedExtensionModel.getConnectionProviders().get(0);
        ConnectionProviderModel originalConnectionProvider = (ConnectionProviderModel)this.originalExtensionModel.getConnectionProviders().get(0);
        MatcherAssert.assertThat((Object)deserializedConnectionProvider.getMinMuleVersion(), (Matcher)Is.is((Object)originalConnectionProvider.getMinMuleVersion()));
    }

    private Set<String> getExtensionTypeIds(JsonObject jsonExtensionModel) {
        JsonArray typesArray = jsonExtensionModel.getAsJsonArray("types");
        HashSet<String> typesSet = new HashSet<String>();
        for (JsonElement next : typesArray) {
            typesSet.add(next.getAsJsonObject().getAsJsonObject("annotations").get("typeId").getAsString());
        }
        return typesSet;
    }

    private void assertComplexParameter(ParameterModel complexParameter) {
        MetadataType type = complexParameter.getType();
        MatcherAssert.assertThat((Object)type, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(ObjectType.class)));
        MatcherAssert.assertThat((Object)JavaTypeUtils.getType((MetadataType)type), (Matcher)CoreMatchers.equalTo(ComplexFieldsType.class));
    }
}

