/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.mockito.Mockito;
import org.mule.runtime.api.metadata.MetadataAttributes;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataKeysContainerBuilder;
import org.mule.runtime.api.metadata.resolving.NamedTypeResolver;
import org.mule.runtime.extension.api.persistence.BasePersistenceTestCase;

public class AbstractMetadataPersistenceTestCase
extends BasePersistenceTestCase {
    protected static final String CATEGORY_NAME = "categoryName";
    protected static final String RESOLVER_NAME = "resolverName";
    protected static final String OUTPUT_RESOLVER_NAME = "outputResolverName";
    protected NamedTypeResolver resolver;
    protected MetadataKeysContainerBuilder builder;
    protected MetadataAttributes attributes;
    protected MetadataKey key;

    @Override
    @Before
    public void setUp() throws IOException {
        super.setUp();
        this.resolver = (NamedTypeResolver)Mockito.mock(NamedTypeResolver.class);
        Mockito.when((Object)this.resolver.getResolverName()).thenReturn((Object)RESOLVER_NAME);
        Mockito.when((Object)this.resolver.getCategoryName()).thenReturn((Object)CATEGORY_NAME);
        this.key = MetadataKeyBuilder.newKey((String)"Key ID").withDisplayName("Key Name").build();
        this.builder = MetadataKeysContainerBuilder.getInstance();
        this.attributes = this.getMetadataAttributes();
    }

    protected MetadataAttributes getMetadataAttributes() {
        return MetadataAttributes.builder().withParameterResolver("carName", RESOLVER_NAME).withCategoryName(CATEGORY_NAME).withKey(this.key).withOutputResolver(OUTPUT_RESOLVER_NAME).withOutputAttributesResolver(OUTPUT_RESOLVER_NAME).build();
    }

    protected void assertMetadataAttributes(MetadataAttributes metadataAttributes, MetadataAttributes expectedAttributes) {
        MatcherAssert.assertThat((Object)metadataAttributes.getCategoryName(), (Matcher)CoreMatchers.is((Object)expectedAttributes.getCategoryName()));
        MatcherAssert.assertThat((Object)metadataAttributes.getKey().isPresent(), (Matcher)CoreMatchers.is((Object)expectedAttributes.getKey().isPresent()));
        MatcherAssert.assertThat((Object)metadataAttributes.getOutputAttributesResolverName(), (Matcher)CoreMatchers.is((Object)expectedAttributes.getOutputAttributesResolverName()));
        MatcherAssert.assertThat((Object)metadataAttributes.getOutputResolverName(), (Matcher)CoreMatchers.is((Object)expectedAttributes.getOutputResolverName()));
        MatcherAssert.assertThat((Object)metadataAttributes.getParameterResolverName("carName"), (Matcher)CoreMatchers.is((Object)RESOLVER_NAME));
    }
}

