/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

public final class DefaultImplementationTypeAdapterFactory<S, T extends S>
implements TypeAdapterFactory {
    private final Class<T> clazz;
    private final Class<S> superClass;

    public DefaultImplementationTypeAdapterFactory(Class<S> superClass, Class<T> clazz) {
        if (!superClass.isAssignableFrom(clazz)) {
            throw new RuntimeException(String.format("[%s] class doesn't extends or implements [%s]", clazz, superClass));
        }
        this.clazz = clazz;
        this.superClass = superClass;
    }

    public <C> TypeAdapter<C> create(Gson gson, TypeToken<C> type) {
        if (this.superClass.isAssignableFrom(type.getRawType())) {
            return gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(this.clazz));
        }
        return null;
    }
}

