/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.dsql;

import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.extension.api.dsql.Direction;
import org.mule.runtime.extension.api.dsql.DsqlQuery;
import org.mule.runtime.extension.api.dsql.EntityType;
import org.mule.runtime.extension.api.dsql.Expression;
import org.mule.runtime.extension.api.dsql.Field;
import org.mule.runtime.extension.api.dsql.QueryBuilder;
import org.mule.runtime.extension.internal.dsql.DefaultDsqlQuery;

public class DefaultQueryBuilder
implements QueryBuilder {
    private EntityType type;
    private final List<Field> fields = new LinkedList<Field>();
    private final List<Field> orderByFields = new LinkedList<Field>();
    private Direction direction;
    private Expression filterExpression;
    private Integer limit;
    private Integer offset;

    private DefaultQueryBuilder() {
    }

    public static DefaultQueryBuilder getInstance() {
        return new DefaultQueryBuilder();
    }

    public QueryBuilder setType(EntityType type) {
        this.type = type;
        return this;
    }

    public QueryBuilder addField(Field field) {
        this.fields.add(field);
        return this;
    }

    public QueryBuilder addOrderByField(Field field) {
        this.orderByFields.add(field);
        return this;
    }

    public QueryBuilder setDirection(Direction direction) {
        this.direction = direction;
        return this;
    }

    public QueryBuilder setFilterExpression(Expression expression) {
        this.filterExpression = expression;
        return this;
    }

    public QueryBuilder setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public QueryBuilder setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public DsqlQuery build() {
        if (this.type == null) {
            throw new IllegalArgumentException("Cannot build query. Missing queried entity type");
        }
        if (this.fields.isEmpty()) {
            this.fields.add(new Field("*"));
        }
        return new DefaultDsqlQuery(this.type, this.fields, this.orderByFields, this.direction, this.filterExpression, this.limit, this.offset);
    }
}

