/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.dsql;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.extension.api.dsql.DsqlParser;
import org.mule.runtime.extension.api.dsql.DsqlQuery;
import org.mule.runtime.extension.internal.expression.FieldComparison;
import org.mule.runtime.extension.internal.value.BooleanValue;
import org.mule.runtime.extension.internal.value.DateTimeValue;
import org.mule.runtime.extension.internal.value.DateValue;
import org.mule.runtime.extension.internal.value.IdentifierValue;
import org.mule.runtime.extension.internal.value.IntegerValue;
import org.mule.runtime.extension.internal.value.MuleExpressionValue;
import org.mule.runtime.extension.internal.value.NullValue;
import org.mule.runtime.extension.internal.value.StringValue;

public class DsqlValueTestCase {
    private static final DsqlParser DSQL_PARSER = DsqlParser.getInstance();

    @Test
    public void parseStringValue() {
        DsqlQuery parse = DSQL_PARSER.parse("dsql:SELECT name from account where lastName = 'de Achaval'");
        Assert.assertThat((Object)((FieldComparison)parse.getFilterExpression()), (Matcher)CoreMatchers.isA(FieldComparison.class));
        FieldComparison fieldComparison = (FieldComparison)parse.getFilterExpression();
        Assert.assertThat((Object)((StringValue)fieldComparison.getValue()), (Matcher)CoreMatchers.isA(StringValue.class));
        StringValue stringValue = (StringValue)fieldComparison.getValue();
        Assert.assertThat((Object)((String)stringValue.getValue()), (Matcher)CoreMatchers.is((Object)"de Achaval"));
    }

    @Test
    public void parseDateTimeWithTimZone1Value() {
        DsqlQuery parse = DSQL_PARSER.parse("dsql:SELECT name from account where birdth > 1999-01-01T23:01:01+01:00");
        Assert.assertThat((Object)((FieldComparison)parse.getFilterExpression()), (Matcher)CoreMatchers.isA(FieldComparison.class));
        FieldComparison fieldComparison = (FieldComparison)parse.getFilterExpression();
        Assert.assertThat((Object)fieldComparison.getValue(), (Matcher)CoreMatchers.instanceOf(DateTimeValue.class));
    }

    @Test
    public void parseDateTimeWithTimZone2Value() {
        DsqlQuery parse = DSQL_PARSER.parse("dsql:SELECT name from account where birdth > 1999-01-01T23:01:01-01:00");
        Assert.assertThat((Object)((FieldComparison)parse.getFilterExpression()), (Matcher)CoreMatchers.isA(FieldComparison.class));
        FieldComparison fieldComparison = (FieldComparison)parse.getFilterExpression();
        Assert.assertThat((Object)fieldComparison.getValue(), (Matcher)CoreMatchers.instanceOf(DateTimeValue.class));
    }

    @Test
    public void parseDateTimeWithTimZone3Value() {
        DsqlQuery parse = DSQL_PARSER.parse("dsql:SELECT name from account where birth > 1999-01-01T23:01:01Z");
        Assert.assertThat((Object)((FieldComparison)parse.getFilterExpression()), (Matcher)CoreMatchers.isA(FieldComparison.class));
        FieldComparison fieldComparison = (FieldComparison)parse.getFilterExpression();
        Assert.assertThat((Object)fieldComparison.getValue(), (Matcher)CoreMatchers.instanceOf(DateTimeValue.class));
    }

    @Test
    public void parseDateTimeWithOutTimZoneValue() {
        DsqlQuery parse = DSQL_PARSER.parse("dsql:SELECT name from account where birth > 2013-09-05T16:39:26.621-03:00");
        Assert.assertThat((Object)((FieldComparison)parse.getFilterExpression()), (Matcher)CoreMatchers.isA(FieldComparison.class));
        FieldComparison fieldComparison = (FieldComparison)parse.getFilterExpression();
        Assert.assertThat((Object)fieldComparison.getValue(), (Matcher)CoreMatchers.instanceOf(DateTimeValue.class));
    }

    @Test
    public void parseDateValue() {
        DsqlQuery parse = DSQL_PARSER.parse("dsql:SELECT name from account where birth > 1999-01-01");
        Assert.assertThat((Object)((FieldComparison)parse.getFilterExpression()), (Matcher)CoreMatchers.isA(FieldComparison.class));
        FieldComparison fieldComparison = (FieldComparison)parse.getFilterExpression();
        Assert.assertThat((Object)fieldComparison.getValue(), (Matcher)CoreMatchers.instanceOf(DateValue.class));
    }

    @Test
    public void parseIntValue() {
        DsqlQuery parse = DSQL_PARSER.parse("dsql:SELECT name from account where age = 30");
        Assert.assertThat((Object)((FieldComparison)parse.getFilterExpression()), (Matcher)CoreMatchers.isA(FieldComparison.class));
        FieldComparison fieldComparison = (FieldComparison)parse.getFilterExpression();
        Assert.assertThat((Object)fieldComparison.getValue(), (Matcher)CoreMatchers.instanceOf(IntegerValue.class));
    }

    @Test
    public void parseBooleanValue() {
        DsqlQuery parse = DSQL_PARSER.parse("dsql:SELECT name from account where registered = true");
        Assert.assertThat((Object)((FieldComparison)parse.getFilterExpression()), (Matcher)CoreMatchers.isA(FieldComparison.class));
        FieldComparison fieldComparison = (FieldComparison)parse.getFilterExpression();
        Assert.assertThat((Object)((BooleanValue)fieldComparison.getValue()), (Matcher)CoreMatchers.isA(BooleanValue.class));
    }

    @Test
    public void parseMuleExpressionValue() {
        DsqlQuery parse = DSQL_PARSER.parse("dsql:SELECT name from account where address = #[flowVars['address']]");
        Assert.assertThat((Object)((FieldComparison)parse.getFilterExpression()), (Matcher)CoreMatchers.isA(FieldComparison.class));
        FieldComparison fieldComparison = (FieldComparison)parse.getFilterExpression();
        Assert.assertThat((Object)((MuleExpressionValue)fieldComparison.getValue()), (Matcher)CoreMatchers.isA(MuleExpressionValue.class));
        MuleExpressionValue stringValue = (MuleExpressionValue)fieldComparison.getValue();
        Assert.assertThat((Object)((String)stringValue.getValue()), (Matcher)CoreMatchers.is((Object)"#[flowVars['address']]"));
    }

    @Test
    public void parseIdentifierValue() {
        DsqlQuery parse = DSQL_PARSER.parse("dsql:SELECT name from account where birth > NEXT_WEEK");
        Assert.assertThat((Object)((FieldComparison)parse.getFilterExpression()), (Matcher)CoreMatchers.isA(FieldComparison.class));
        FieldComparison fieldComparison = (FieldComparison)parse.getFilterExpression();
        Assert.assertThat((Object)((IdentifierValue)fieldComparison.getValue()), (Matcher)CoreMatchers.isA(IdentifierValue.class));
        IdentifierValue stringValue = (IdentifierValue)fieldComparison.getValue();
        Assert.assertThat((Object)((String)stringValue.getValue()), (Matcher)CoreMatchers.is((Object)"NEXT_WEEK"));
    }

    @Test
    public void parseNullValue() {
        DsqlQuery parse = DSQL_PARSER.parse("dsql:SELECT name from account where address = null");
        Assert.assertThat((Object)((FieldComparison)parse.getFilterExpression()), (Matcher)CoreMatchers.isA(FieldComparison.class));
        FieldComparison fieldComparison = (FieldComparison)parse.getFilterExpression();
        Assert.assertThat((Object)((NullValue)fieldComparison.getValue()), (Matcher)CoreMatchers.isA(NullValue.class));
    }
}

