/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.dsql;

import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.extension.api.dsql.DefaultQueryBuilder;
import org.mule.runtime.extension.api.dsql.Direction;
import org.mule.runtime.extension.api.dsql.DsqlQueryTranslator;
import org.mule.runtime.extension.api.dsql.EntityType;
import org.mule.runtime.extension.api.dsql.Field;
import org.mule.runtime.extension.api.dsql.QueryTranslator;
import org.mule.runtime.extension.api.dsql.Value;
import org.mule.runtime.extension.internal.expression.And;
import org.mule.runtime.extension.internal.expression.Expression;
import org.mule.runtime.extension.internal.expression.FieldComparison;
import org.mule.runtime.extension.internal.expression.Or;
import org.mule.runtime.extension.internal.operator.BinaryOperator;
import org.mule.runtime.extension.internal.operator.EqualsOperator;
import org.mule.runtime.extension.internal.operator.GreaterOperator;
import org.mule.runtime.extension.internal.operator.LessOperator;
import org.mule.runtime.extension.internal.operator.NotEqualsOperator;
import org.mule.runtime.extension.internal.value.IdentifierValue;
import org.mule.runtime.extension.internal.value.IntegerValue;
import org.mule.runtime.extension.internal.value.NumberValue;
import org.mule.runtime.extension.internal.value.StringValue;

public class DsqlQueryTranslatorTestCase {
    @Test
    public void testBasicQueryVisitor() {
        DefaultQueryBuilder queryBuilder = DefaultQueryBuilder.getInstance();
        queryBuilder.addField(new Field("name", "string"));
        queryBuilder.addField(new Field("lastName", "string"));
        queryBuilder.setType(new EntityType("Account"));
        DsqlQueryTranslator visitor = new DsqlQueryTranslator();
        queryBuilder.build().translate((QueryTranslator)visitor);
        Assert.assertEquals((Object)"SELECT name,lastName FROM Account", (Object)visitor.getTranslation());
    }

    @Test
    public void testFiltersQueryVisitor() {
        DefaultQueryBuilder queryBuilder = DefaultQueryBuilder.getInstance();
        queryBuilder.addField(new Field("name", "string"));
        queryBuilder.setType(new EntityType("Account"));
        FieldComparison comparision = new FieldComparison((BinaryOperator)new LessOperator(), new Field("age", "int"), (Value)new IntegerValue(Integer.valueOf(18)));
        FieldComparison anotherComparision = new FieldComparison((BinaryOperator)new GreaterOperator(), new Field("grade", "int"), (Value)new IntegerValue(Integer.valueOf(0)));
        And simpleAnd = new And((Expression)comparision, (Expression)anotherComparision);
        queryBuilder.setFilterExpression((Expression)simpleAnd);
        DsqlQueryTranslator visitor = new DsqlQueryTranslator();
        queryBuilder.build().translate((QueryTranslator)visitor);
        Assert.assertEquals((Object)"SELECT name FROM Account WHERE (age < 18 AND grade > 0)", (Object)visitor.getTranslation());
    }

    @Test
    public void testFiltersQueryVisitorWithDouble() {
        DefaultQueryBuilder queryBuilder = DefaultQueryBuilder.getInstance();
        queryBuilder.addField(new Field("name", "string"));
        queryBuilder.setType(new EntityType("Account"));
        FieldComparison comparision = new FieldComparison((BinaryOperator)new LessOperator(), new Field("age", "int"), (Value)new NumberValue(Double.valueOf(18.5)));
        FieldComparison anotherComparision = new FieldComparison((BinaryOperator)new GreaterOperator(), new Field("grade", "int"), (Value)new NumberValue(Double.valueOf(0.5)));
        And simpleAnd = new And((Expression)comparision, (Expression)anotherComparision);
        queryBuilder.setFilterExpression((Expression)simpleAnd);
        DsqlQueryTranslator visitor = new DsqlQueryTranslator();
        queryBuilder.build().translate((QueryTranslator)visitor);
        Assert.assertEquals((Object)"SELECT name FROM Account WHERE (age < 18.5 AND grade > 0.5)", (Object)visitor.getTranslation());
    }

    @Test
    public void testPrecedence() {
        DefaultQueryBuilder queryBuilder = DefaultQueryBuilder.getInstance();
        queryBuilder.addField(new Field("name", "string"));
        queryBuilder.setType(new EntityType("Account"));
        FieldComparison comparision = new FieldComparison((BinaryOperator)new NotEqualsOperator(), new Field("age", "int"), (Value)new IntegerValue(Integer.valueOf(18)));
        FieldComparison anotherComparision = new FieldComparison((BinaryOperator)new GreaterOperator(), new Field("grade", "int"), (Value)new IntegerValue(Integer.valueOf(0)));
        Or simpleOr = new Or((Expression)comparision, (Expression)anotherComparision);
        And simpleAnd = new And((Expression)simpleOr, (Expression)anotherComparision);
        queryBuilder.setFilterExpression((Expression)simpleAnd);
        DsqlQueryTranslator visitor = new DsqlQueryTranslator();
        queryBuilder.build().translate((QueryTranslator)visitor);
        Assert.assertEquals((Object)"SELECT name FROM Account WHERE ((age <> 18 OR grade > 0) AND grade > 0)", (Object)visitor.getTranslation());
    }

    @Test
    public void testOrderBy() {
        DefaultQueryBuilder queryBuilder = DefaultQueryBuilder.getInstance();
        queryBuilder.addField(new Field("name", "string"));
        queryBuilder.setType(new EntityType("Account"));
        queryBuilder.addOrderByField(new Field("name", "string"));
        queryBuilder.addOrderByField(new Field("age", "int"));
        queryBuilder.setDirection(Direction.ASC);
        FieldComparison comparision = new FieldComparison((BinaryOperator)new LessOperator(), new Field("age", "int"), (Value)new IntegerValue(Integer.valueOf(18)));
        FieldComparison anotherComparision = new FieldComparison((BinaryOperator)new EqualsOperator(), new Field("grade", "int"), (Value)new IntegerValue(Integer.valueOf(0)));
        Or simpleOr = new Or((Expression)comparision, (Expression)anotherComparision);
        And simpleAnd = new And((Expression)simpleOr, (Expression)anotherComparision);
        queryBuilder.setFilterExpression((Expression)simpleAnd);
        DsqlQueryTranslator visitor = new DsqlQueryTranslator();
        queryBuilder.build().translate((QueryTranslator)visitor);
        String select = "SELECT name FROM Account WHERE ((age < 18 OR grade = 0) AND grade = 0) ORDER BY name,age ASC";
        Assert.assertEquals((Object)select, (Object)visitor.getTranslation());
    }

    @Test
    public void testLimitAndOffset() {
        DefaultQueryBuilder queryBuilder = DefaultQueryBuilder.getInstance();
        queryBuilder.addField(new Field("name", "string"));
        queryBuilder.setType(new EntityType("Account"));
        queryBuilder.addOrderByField(new Field("name", "string"));
        queryBuilder.addOrderByField(new Field("age", "int"));
        queryBuilder.setDirection(Direction.DESC);
        queryBuilder.setLimit(10);
        queryBuilder.setOffset(20);
        FieldComparison comparision = new FieldComparison((BinaryOperator)new LessOperator(), new Field("age", "int"), (Value)new IntegerValue(Integer.valueOf(18)));
        FieldComparison anotherComparision = new FieldComparison((BinaryOperator)new GreaterOperator(), new Field("grade", "int"), (Value)new IntegerValue(Integer.valueOf(0)));
        Or simpleOr = new Or((Expression)comparision, (Expression)anotherComparision);
        And simpleAnd = new And((Expression)simpleOr, (Expression)anotherComparision);
        queryBuilder.setFilterExpression((Expression)simpleAnd);
        DsqlQueryTranslator visitor = new DsqlQueryTranslator();
        queryBuilder.build().translate((QueryTranslator)visitor);
        String select = "SELECT name FROM Account WHERE ((age < 18 OR grade > 0) AND grade > 0) ORDER BY name,age DESC LIMIT 10 OFFSET 20";
        Assert.assertEquals((Object)select, (Object)visitor.getTranslation());
    }

    @Test
    public void testIdentifierValue() {
        DefaultQueryBuilder queryBuilder = DefaultQueryBuilder.getInstance();
        queryBuilder.addField(new Field("name", "string"));
        queryBuilder.setType(new EntityType("Account"));
        queryBuilder.addOrderByField(new Field("name", "string"));
        queryBuilder.addOrderByField(new Field("age", "int"));
        queryBuilder.setDirection(Direction.ASC);
        queryBuilder.setLimit(10);
        queryBuilder.setOffset(20);
        FieldComparison comparision = new FieldComparison((BinaryOperator)new LessOperator(), new Field("age", "int"), (Value)new IntegerValue(Integer.valueOf(18)));
        FieldComparison otherComparision = new FieldComparison((BinaryOperator)new GreaterOperator(), new Field("grade", "int"), (Value)IdentifierValue.fromLiteral((String)"NEXT_WEEK"));
        Or simpleOr = new Or((Expression)comparision, (Expression)otherComparision);
        And simpleAnd = new And((Expression)simpleOr, (Expression)otherComparision);
        queryBuilder.setFilterExpression((Expression)simpleAnd);
        DsqlQueryTranslator visitor = new DsqlQueryTranslator();
        queryBuilder.build().translate((QueryTranslator)visitor);
        String select = "SELECT name FROM Account WHERE ((age < 18 OR grade > NEXT_WEEK) AND grade > NEXT_WEEK) ORDER BY name,age ASC LIMIT 10 OFFSET 20";
        Assert.assertEquals((Object)select, (Object)visitor.getTranslation());
    }

    @Test
    public void testStringValue() {
        DefaultQueryBuilder queryBuilder = DefaultQueryBuilder.getInstance();
        queryBuilder.addField(new Field("name", "string"));
        queryBuilder.setType(new EntityType("Account"));
        queryBuilder.addOrderByField(new Field("name", "string"));
        queryBuilder.addOrderByField(new Field("age", "int"));
        queryBuilder.setDirection(Direction.ASC);
        queryBuilder.setLimit(10);
        queryBuilder.setOffset(20);
        FieldComparison comparision = new FieldComparison((BinaryOperator)new LessOperator(), new Field("age", "int"), (Value)new StringValue("old"));
        FieldComparison otherComparision = new FieldComparison((BinaryOperator)new GreaterOperator(), new Field("grade", "int"), (Value)IdentifierValue.fromLiteral((String)"NEXT_WEEK"));
        Or simpleOr = new Or((Expression)comparision, (Expression)otherComparision);
        And simpleAnd = new And((Expression)simpleOr, (Expression)otherComparision);
        queryBuilder.setFilterExpression((Expression)simpleAnd);
        DsqlQueryTranslator visitor = new DsqlQueryTranslator();
        queryBuilder.build().translate((QueryTranslator)visitor);
        String select = "SELECT name FROM Account WHERE ((age < 'old' OR grade > NEXT_WEEK) AND grade > NEXT_WEEK) ORDER BY name,age ASC LIMIT 10 OFFSET 20";
        Assert.assertEquals((Object)select, (Object)visitor.getTranslation());
    }
}

