/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.dsql;

import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.extension.api.dsql.Direction;
import org.mule.runtime.extension.api.dsql.DsqlParser;
import org.mule.runtime.extension.api.dsql.DsqlQuery;
import org.mule.runtime.extension.api.dsql.Field;
import org.mule.runtime.extension.internal.expression.FieldComparison;
import org.mule.runtime.extension.internal.operator.EqualsOperator;
import org.mule.runtime.extension.internal.operator.LessOperator;

public class DsqlParserTestCase {
    private static final DsqlParser PARSER = DsqlParser.getInstance();

    @Test
    public void testEmptyParse() {
        try {
            DsqlQuery dsqlQuery = PARSER.parse("dsql:select * from users");
            Assert.assertEquals((Object)"*", (Object)((Field)dsqlQuery.getFields().get(0)).getName());
            Assert.assertEquals((Object)"users", (Object)dsqlQuery.getType().getName());
        }
        catch (Throwable e) {
            Assert.fail();
        }
    }

    @Test
    public void testWithMuleExpressionDsql() {
        DsqlQuery dsqlQuery = PARSER.parse("dsql:select * from addresses where name='#[payload.get(\\'id\\')]' order by name desc");
        Assert.assertEquals((Object)"*", (Object)((Field)dsqlQuery.getFields().get(0)).getName());
        Assert.assertEquals((Object)"addresses", (Object)dsqlQuery.getType().getName());
        Assert.assertTrue((boolean)(dsqlQuery.getFilterExpression() instanceof FieldComparison));
        Assert.assertEquals((Object)"name", (Object)((FieldComparison)dsqlQuery.getFilterExpression()).getField().getName());
        Assert.assertTrue((boolean)(((FieldComparison)dsqlQuery.getFilterExpression()).getOperator() instanceof EqualsOperator));
        Assert.assertEquals((Object)"'#[payload.get(\\'id\\')]'", (Object)((FieldComparison)dsqlQuery.getFilterExpression()).getValue().toString());
        Assert.assertEquals((Object)"name", (Object)((Field)dsqlQuery.getOrderByFields().get(0)).getName());
    }

    @Test
    public void testWithMuleExpression() {
        DsqlQuery dsqlQuery = PARSER.parse("dsql:SELECT * from addresses where name='#[payload.get(\\'id\\')]' order by name desc");
        Assert.assertEquals((Object)"*", (Object)((Field)dsqlQuery.getFields().get(0)).getName());
        Assert.assertEquals((Object)"addresses", (Object)dsqlQuery.getType().getName());
        Assert.assertTrue((boolean)(dsqlQuery.getFilterExpression() instanceof FieldComparison));
        Assert.assertEquals((Object)"name", (Object)((FieldComparison)dsqlQuery.getFilterExpression()).getField().getName());
        Assert.assertTrue((boolean)(((FieldComparison)dsqlQuery.getFilterExpression()).getOperator() instanceof EqualsOperator));
        Assert.assertEquals((Object)"'#[payload.get(\\'id\\')]'", (Object)((FieldComparison)dsqlQuery.getFilterExpression()).getValue().toString());
        Assert.assertEquals((Object)"name", (Object)((Field)dsqlQuery.getOrderByFields().get(0)).getName());
    }

    @Test
    public void testWithMuleExpressionFlowVarDsql() {
        DsqlQuery dsqlQuery = PARSER.parse("dsql:select id,name from addresses where name<'#[flowVars[\"id\"]]' order by name desc");
        Assert.assertEquals((long)2L, (long)dsqlQuery.getFields().size());
        Assert.assertEquals((Object)"id", (Object)((Field)dsqlQuery.getFields().get(0)).getName());
        Assert.assertEquals((Object)"name", (Object)((Field)dsqlQuery.getFields().get(1)).getName());
        Assert.assertEquals((Object)"addresses", (Object)dsqlQuery.getType().getName());
        Assert.assertTrue((boolean)(dsqlQuery.getFilterExpression() instanceof FieldComparison));
        Assert.assertEquals((Object)"name", (Object)((FieldComparison)dsqlQuery.getFilterExpression()).getField().getName());
        Assert.assertTrue((boolean)(((FieldComparison)dsqlQuery.getFilterExpression()).getOperator() instanceof LessOperator));
        Assert.assertEquals((Object)"'#[flowVars[\"id\"]]'", (Object)((FieldComparison)dsqlQuery.getFilterExpression()).getValue().toString());
        Assert.assertEquals((Object)"name", (Object)((Field)dsqlQuery.getOrderByFields().get(0)).getName());
        Assert.assertEquals((Object)Direction.DESC, (Object)dsqlQuery.getDirection());
    }

    @Test
    public void testWithMuleExpressionFlowVar() {
        DsqlQuery dsqlQuery = PARSER.parse("dsql:SELECT id,name from addresses where name<'#[flowVars[\"id\"]]' order by name desc");
        Assert.assertEquals((long)2L, (long)dsqlQuery.getFields().size());
        Assert.assertEquals((Object)"id", (Object)((Field)dsqlQuery.getFields().get(0)).getName());
        Assert.assertEquals((Object)"name", (Object)((Field)dsqlQuery.getFields().get(1)).getName());
        Assert.assertEquals((Object)"addresses", (Object)dsqlQuery.getType().getName());
        Assert.assertTrue((boolean)(dsqlQuery.getFilterExpression() instanceof FieldComparison));
        Assert.assertEquals((Object)"name", (Object)((FieldComparison)dsqlQuery.getFilterExpression()).getField().getName());
        Assert.assertTrue((boolean)(((FieldComparison)dsqlQuery.getFilterExpression()).getOperator() instanceof LessOperator));
        Assert.assertEquals((Object)"'#[flowVars[\"id\"]]'", (Object)((FieldComparison)dsqlQuery.getFilterExpression()).getValue().toString());
        Assert.assertEquals((Object)"name", (Object)((Field)dsqlQuery.getOrderByFields().get(0)).getName());
    }
}

