/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.extension.internal;

import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;

import java.util.LinkedList;
import java.util.List;

/**
 * A helper class to handle AST ElementS
 * 
 * @since 1.4
 */
public final class ElementASTUtils {

  private ElementASTUtils() {};

  public static List<ExtensionParameter> getParameterGroupExtensionParameters(MethodElementAST methodElement) {
    List<ExtensionParameter> parameters = new LinkedList<>(methodElement.getParametersAnnotatedWith(ParameterGroup.class));
    parameters.addAll(methodElement.getParametersAnnotatedWith(org.mule.sdk.api.annotation.param.ParameterGroup.class));
    return parameters;
  }

}
